<?php
defined('TYPO3_MODE') or die();

/***************
 * New fields in table:tt_content
 */
$tempContentColumns = [

    'tx_amdsbear_header_position' => [
        'label' => 'Header Position',
        'exclude' => 1,
        'displayCond' => [
            'OR' => [
                'FIELD:CType:=:textmedia',
                'FIELD:CType:=:textpic',
            ],
        ],
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['Beside or under the image (default)', 'beside'],
                ['Above the image', 'above']
            ],
            'default' => 'beside'
        ]
    ],
    
    
    'tx_amdsbear_container' => [
        'label' => 'Container with full-fluid width',
        'exclude' => 1,
        'config' => [
            'type' => 'check',
            'items' => [
                ['add class "container-fluid"', '']
            ]
        ]
    ],
    'tx_amdsbear_context_classes' => [
        'label' => 'Context Classes',
        'exclude' => 1,
        'config' => [
            'type' => 'select',
            'renderType' => 'selectMultipleSideBySide',
            'items' => [
                ['primary', 'bg-primary'],
                ['secondary', 'bg-secondary'],
                ['light', 'bg-light'],
                ['dark', 'bg-dark'],
                
            ]
        ]
    ],
    'tx_amdsbear_extra_class' => [
        'label' => 'Extra HTML-Class',
        'exclude' => 1,
        'config' => [
            'type' => 'input',
            'eval' => 'trim',
            'size' => 255
        ]
    ],
    'tx_amdsbear_inTextImgRowWidth' => [
        'label' => 'Gallery row width in %',
        'exclude' => 1,
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['auto', 'auto'],
                ['25 %', 'w-25'],
                ['33 %', 'w-33'],
                ['50 %', 'w-50'],
                ['66 %', 'w-66'],
                ['75 %', 'w-75'],
                ['none', 'none']
            ],
            'default' => 'auto'
        ]
    ],

];

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_content', $tempContentColumns);
unset($tempContentColumns);

\TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\B13\Container\Tca\Registry::class)->configureContainer(
    (
        new \B13\Container\Tca\ContainerConfiguration(
            'b13-1cols-container', // CType
            '1 Column Container (no header)', // label
            'Some Description of the Container', // description
            [
                [
                    ['name' => 'content', 'colPos' => 151]
                ]
            ] // grid configuration
        )
    )
        // set an optional icon configuration
        ->setIcon('EXT:container/Resources/Public/Icons/container-1col.svg')
);

\TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\B13\Container\Tca\Registry::class)->configureContainer(
    (
        new \B13\Container\Tca\ContainerConfiguration(
            'b13-2cols-container', // CType
            '2 Column Container (no header)', // label
            'Some Description of the Container', // description
            [
                [
                    ['name' => 'left side', 'colPos' => 201],
                    ['name' => 'right side', 'colPos' => 202]
                ]
            ] // grid configuration
        )
    )
        // set an optional icon configuration
        ->setIcon('EXT:container/Resources/Public/Icons/container-2col.svg')
);

\TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\B13\Container\Tca\Registry::class)->configureContainer(
    (
        new \B13\Container\Tca\ContainerConfiguration(
            'b13-2cols-with-header-container', // CType
            '2 Column Container With Header', // label
            'Some Description of the Container', // description
            [
                [
                    ['name' => 'header', 'colPos' => 200, 'colspan' => 2, 'allowed' => ['CType' => 'header, textmedia']]
                ],
                [
                    ['name' => 'left side', 'colPos' => 201],
                    ['name' => 'right side', 'colPos' => 202]
                ]
            ] // grid configuration
        )
    )
        // set an optional icon configuration
        ->setIcon('EXT:container/Resources/Public/Icons/container-2col.svg')
);

\TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\B13\Container\Tca\Registry::class)->configureContainer(
    (
        new \B13\Container\Tca\ContainerConfiguration(
            'b13-3cols-container', // CType
            '3 Column Container (no header)', // label
            'Some Description of the Container', // description
            [
                [
                    ['name' => 'left', 'colPos' => 301],
                    ['name' => 'middle', 'colPos' => 302],
                    ['name' => 'right', 'colPos' => 303]
                ]
            ] // grid configuration
        )
    )
        // set an optional icon configuration
        ->setIcon('EXT:container/Resources/Public/Icons/container-3col.svg')
);

\TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\B13\Container\Tca\Registry::class)->configureContainer(
    (
        new \B13\Container\Tca\ContainerConfiguration(
            'b13-3cols-with-header-container', // CType
            '3 Column Container With Header', // label
            'Some Description of the Container', // description
            [
                [
                    ['name' => 'header', 'colPos' => 300, 'colspan' => 3, 'allowed' => ['CType' => 'header, textmedia']]
                ],
                [
                    ['name' => 'left', 'colPos' => 301],
                    ['name' => 'middle', 'colPos' => 302],
                    ['name' => 'right', 'colPos' => 303]
                ]
            ] // grid configuration
        )
    )
        // set an optional icon configuration
        ->setIcon('EXT:container/Resources/Public/Icons/container-3col.svg')
);

/**
 * Add flexForm
 */
//\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPiFlexFormValue (
//    '*',
//    'FILE:EXT:stwmue_sitepackage/Configuration/FlexForms/Columns2.xml',
//    'b13-2cols-container'
//);