<?php
namespace AmadeusAgentur\Template\Muenchberg\Service;

use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
* BrandingService
*/
class BrandingService
{
    /**
    * @var string
    */
    const EXT_KEY = 'stwmue_sitepackage';

    public function setBackendStyling($extension = null)
    {
        if ($extension === BrandingService::EXT_KEY && class_exists(ExtensionConfiguration::class)) {
            $extensionConfiguration = GeneralUtility::makeInstance(
                ExtensionConfiguration::class
            );
            $backendConfiguration = $extensionConfiguration->get('backend');

            $backendConfiguration['loginLogo'] = 'EXT:' . BrandingService::EXT_KEY . '/Resources/Public/Images/Backend/login-logo.svg';
            $backendConfiguration['loginBackgroundImage'] = 'EXT:' . BrandingService::EXT_KEY . '/Resources/Public/Images/Backend/login-background-image.jpg';
            $backendConfiguration['loginHighlightColor'] = '#f59c00';
            $backendConfiguration['loginFootnote'] = 'www.amadeus-agentur.com';

            $extensionConfiguration->set('backend', '', $backendConfiguration);
        }
    }

}
