/* File: gulpfile.js */


// grab our gulp packages
var gulp = require('gulp'),
    babel = require('gulp-babel'),
    del = require('del'),
    browser = require('browser-sync'),
    gulpif = require('gulp-if'),
    log = require('fancy-log'),
    autoprefixer = require('gulp-autoprefixer'),
    concat = require('gulp-concat'),
    cleanCSS = require('gulp-clean-css'),
    sass = require('gulp-sass'),
    rename = require('gulp-rename'),
    sourcemaps = require('gulp-sourcemaps'),
    uglify = require('gulp-uglify'),
    webpack = require('webpack-stream'),
    plumber = require('gulp-plumber')


//
var basePaths = {
    public: '../Resources/Public/',
    private: '../Resources/Private/'
};

var paths = {
    styles: {
        src: basePaths.private + 'Scss/',
        dest: basePaths.public + 'Css/'
    },
    scripts: {
        src: basePaths.private + 'JavaScript/',
        dest: basePaths.public + 'JavaScript/'
    },
    images: basePaths.public + 'Images/'

};


// environmental settings for production/deployment

var $isProduction = (process.argv[3] == "--production"),
    $environment = (process.argv[4] == "--live" ? 'https://www.stadtwerke-muenchberg.de' : 'https://dev.stadtwerke-muenchberg.de');


var isProduction = false,
    sourceMap = true,
    deployDev = true,
    deployLive = false;

if ($isProduction) {
    isProduction = true;
    sourceMap = false;
    deployDev = true;
    deployLive = true;
}


function clean(done) {
    del([
        '../Resources/Public/Css/**/*',
        '../Resources/Public/JavaScript/**/*'
    ], {
        force: true
    });
    done();
}


// Less to CSS: Run manually with: "gulp build-css"
function stylesheet() {
    return gulp.src([paths.styles.src + 'theme.scss', paths.styles.src + 'ie11.scss'] )
        .pipe(gulpif(!$isProduction, sourcemaps.init()))
        .pipe(sass({
            includePaths: ['node_modules/']
        }).on('error', sass.logError))

        .pipe(autoprefixer({
            browserlist: ['>1% in DE']
        }))

        .pipe(gulpif($isProduction, cleanCSS({
                level: 1,
                format: (!$isProduction ? 'beautify' : 'none'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        )))
        .pipe(gulpif(!$isProduction, sourcemaps.write()))
        .pipe(gulp.dest(paths.styles.dest))

        .pipe(browser.reload({stream: true}));
}


function jsLibs() {
    return gulp.src([
        'node_modules/jquery/dist/jquery.min.js',
        'node_modules/@fancyapps/fancybox/dist/jquery.fancybox.min.js',
    ])
        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}

function cssLibs() {
    return gulp.src([
        'node_modules/@fancyapps/fancybox/dist/jquery.fancybox.min.css',
    ])
        .pipe(gulp.dest(paths.styles.dest)).on('error', function (err) {
            log(err);
        })
}

function jsBootstrap() {
    return gulp.src([
        'node_modules/bootstrap/js/src/util.js',
        'node_modules/bootstrap/js/src/alert.js',
        'node_modules/bootstrap/js/src/collapse.js',
        'node_modules/bootstrap/js/src/dropdown.js',
        'node_modules/bootstrap/js/src/scrollspy.js',
        'node_modules/bootstrap/js/src/tab.js',
        'node_modules/bootstrap/js/src/popover.js',
        'node_modules/bootstrap/js/src/modal.js',
        'node_modules/bootstrap/js/src/tooltip.js',
        '../Resources/Private/JavaScript/scrolltop.js',
        '../Resources/Private/JavaScript/bootstrap.init.js'
    ])
        .pipe(webpack(require('./webpack.config.js')))

        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}



// function jsInit() {
//     return gulp.src(paths.scripts.src + '*.js')
//         .pipe(concat('init.js'))
//         .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
//             log(err);
//         })
// }


function server(done) {
    browser.init({
        open: false,
        online: true,
        reloadOnRestart: true,
        logConnections: true,
        proxy: $environment,
        https: true,
        serveStatic: [{
            route: ['typo3conf/ext/stwmue_sitepackage/Resources/Public', 'typo3temp/assets/compressed'],
            dir: ['../Resources/Public/']
        }],
        notify: {
            styles: {
                top: 'auto',
                bottom: '0',
                borderRadius: '5px 0px 0px'
            }
        }
    });
    done();
}


function watch() {
    gulp.watch(paths.styles.src + '**/*.scss').on('all', gulp.series(stylesheet));
    gulp.watch(paths.scripts.src + '**/*.js').on('all', gulp.series(jsLibs, jsBootstrap, browser.reload));
}


// Build the "dist" folder by running all of the below tasks
gulp.task('build',
    gulp.series(clean, gulp.parallel(stylesheet, jsLibs, cssLibs, jsBootstrap))
);

// Build the site, run the server, and watch for file changes
gulp.task('default',
    gulp.series('build', server, watch)
);
