initFloatingLabels = function (_formControls) {
    // Hide labels by default if placeholders are supported
    if ($.support.placeholder) {
        _formControls.each(function () {
            if ($(this).val() == '') {
                $(this).parent().addClass('has-floatinglabel js-hide-label');
            } else {
                $(this).parent().addClass('has-floatinglabel');
            }
        });
    }

    //Reapply Events
    _formControls.on('keyup blur focus', labelEvent)

    $('[data-copy-button]').on('click', function (e) {
        formControls = $('.form-control');
        initFloatingLabels(formControls);
    })
};

labelEvent = function (_evt) {
    // Cache our selectors
    var $this = $(this),
        $parent = $this.parent();

    // Add or remove classes
    if (_evt.type == 'keyup') {
        if ($this.val() == '') {
            $parent.addClass('js-hide-label');
        } else {
            $parent.removeClass('js-hide-label');
        }
    } else if (_evt.type == 'blur') {
        if ($this.val() == '') {
            $parent.addClass('js-hide-label');
        } else {
            $parent.removeClass('js-hide-label').addClass('js-unhighlight-label');
        }
    } else if (_evt.type == 'focus') {
        if ($this.val() !== '') {
            $parent.removeClass('js-unhighlight-label');
        }
    }
};

$(function () {
    //Check Placeholder support
    $.support.placeholder = (function () {
        var i = document.createElement('input');
        return 'placeholder' in i;
    })();

    formControls = $('.form-control');
    initFloatingLabels(formControls);
});


