<?php
if (!defined('TYPO3_MODE')) {
    die ('Access denied.');
}

/**
 * Style Login according to domain
 * TYPO3_CONTEXT Development
 */

if (isset($_SERVER['SERVER_NAME'])) {
    if ($_SERVER['SERVER_NAME'] == "www.stadtwerke-muenchberg.de") {
        $GLOBALS['TYPO3_CONF_VARS']['EXTENSIONS']['backend']['loginLogo'] = 'EXT:stwmue_sitepackage/Resources/Public/Images/Backend/login-logo.svg';
    }
    if ($_SERVER['SERVER_NAME'] == "www.stadtwerke-schwarzenbach.de") {
        $GLOBALS['TYPO3_CONF_VARS']['EXTENSIONS']['backend']['loginLogo'] = 'EXT:stwsas_sitepackage/Resources/Public/Images/Backend/login-logo.svg';
    }
}

$GLOBALS['TYPO3_CONF_VARS'] = array_replace_recursive(
    $GLOBALS['TYPO3_CONF_VARS'],
    [
        'DB' => [
            'Connections' => [
                'Default' => [
                    'dbname' => getenv("TYPO3_DB_DBNAME"),
                    'host' => getenv("TYPO3_DB_HOST"),
                    'password' => getenv("TYPO3_DB_PASSWORD"),
                    'port' => getenv("TYPO3_DB_PORT"),
                    'user' => getenv("TYPO3_DB_USER"),
                    'driver' => getenv("TYPO3_DB_DRIVER")
                ],
            ],
        ],
    ]
);

if (getenv('IS_DDEV_PROJECT') == 'true') {
    $GLOBALS['TYPO3_CONF_VARS'] = array_replace_recursive(
        $GLOBALS['TYPO3_CONF_VARS'],
        [
            // This GFX configuration allows processing by installed ImageMagick 6
            'GFX' => [
                'processor' => 'ImageMagick',
                'processor_path' => '/usr/bin/',
                'processor_path_lzw' => '/usr/bin/',
            ],
            // This mail configuration sends all emails to mailhog
            'MAIL' => [
                'transport' => 'smtp',
                'transport_smtp_server' => 'localhost:1025',
            ],
            'SYS' => [
                'trustedHostsPattern' => '.*.*',
                'devIPmask' => '*',
                'displayErrors' => 1,
            ],
        ]
    );
}
