import Headroom from "headroom.js";


// grab an element
const qs = document.querySelector("#qs-wrapper");
// construct an instance of Headroom, passing the element


const options = {
    // vertical offset in px before element is first unpinned
    offset: window.innerHeight / 2,
    // or you can specify tolerance individually for up/down scroll
    tolerance: {
        up: 20,
        down: 5
    },
    // css classes to apply
    classes: {
        // when element is initialised
        initial: 'is--sticky',
        // when scrolling up
        pinned: "is--pinned",
        // when scrolling down
        unpinned: "is--unpinned",
        // when above offset
        top: "is--top",
        // when below offset
        notTop: "is--not-top",
        // when at bottom of scoll area
        bottom: "is--bottom",
        // when not at bottom of scroll area
        notBottom: "is--not-bottom"
    }
};

const headroom = new Headroom(qs, options);

// initialise
headroom.init();
