import * as Popper from '@popperjs/core';
import Modal from 'bootstrap/js/src/modal';
import Tooltip from 'bootstrap/js/src/tooltip';
import Collapse from 'bootstrap/js/src/collapse';
import Dropdown from 'bootstrap/js/src/dropdown';
import Popover from 'bootstrap/js/src/popover';
import Offcanvas from 'bootstrap/js/src/offcanvas';


var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'))
var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
    return new Dropdown(dropdownToggleEl)
})

var tooltipTriggerList = [].slice.call(document.querySelectorAll('.download-link'))
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new Tooltip(tooltipTriggerEl, {html: true})
})

const offcanvasElementList = document.querySelectorAll('.offcanvas')
const offcanvasList = [...offcanvasElementList].map(offcanvasEl => new Offcanvas(offcanvasEl))


/* look for responsive tables and when found apply '.is-pinned' to be able to style sticky th cells */
const tables = document.querySelectorAll('.table-responsive')

tables.forEach((table) => {
    table.addEventListener('scroll', function (e){
        e.currentTarget.classList.toggle('is-pinned', e.currentTarget.scrollLeft > 0)
    });
});


// import $ from 'jquery';
//
// $(function ($) {
//     $('[data-toggle="tooltip"]').tooltip()
// })

const qsItem = document.querySelector('.qs-item')
const qsOverlay = document.querySelector('.qs-overlay')
const qsToggler = document.querySelector('.qs-toggler')
const qsTogglerNot = document.querySelector('.qs-toggler:not(collapsed)')

qsItem.addEventListener('show.bs.collapse',  evt => {
        qsOverlay.classList.add("show");
    });

// qsTogglerNot.addEventListener('click', evt => {
//     qsOverlay.classList.remove("show");
// });

qsOverlay.addEventListener('click', evt => {
    console.log(evt)
    evt.target.classList.remove('show')
} )


// overlay einblenden - immer
//
// $('.qs-item')
//     .on('show.bs.collapse', function () {
//         $('.qs-overlay').addClass('show')
//     });
//
// // schließen wenn klick auf toggler, der schon offen ist
// $('.qs-toggler:not(collapsed)').on('click', function () {
//     $('.qs-overlay').removeClass('show')
// });
//
//
// // klick auf overlay schließt geöffnetes item und macht sich selbst unsichtbar
// $('.qs-overlay')
//     .on('click', function () {
//         $('.qs-item').collapse('hide');
//         $(this).removeClass('show')
//     });
