<?php
namespace AmadeusAgentur\Stwm_Sitepackage\ViewHelpers;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

/***************************************************************
 *  Lend from cewrapInArrayViewHelper.php
 ***************************************************************/

class ClassSelectViewHelper extends AbstractViewHelper {

    /**
     * Parse selected classes
     *
     * @param string $classes: CSS classes to parse
     * @param string $prefix: Prefix for CSS class
     * @param string $prefixExclusion: CSS classes with no prefix
     * @return string
     */
    public function render($classes = NULL, $prefix = NULL, $prefixExclusion = NULL) {
        if(!$classes) {
            $classes = $this->renderChildren();
        }
        if($classes) {
            $classes = GeneralUtility::trimExplode(',', $classes);
            if($prefix) {
                $prefixExclusion = GeneralUtility::trimExplode(',', $prefixExclusion);
                foreach($classes as &$class) {
                    if(!in_array($class, $prefixExclusion)) {
                        $class = $prefix . $class;
                    }
                }
            }
            //return implode($classes, ' ');
            return ' ' . implode(' ', $classes );
        }
    }
}
