<?php
defined('TYPO3_MODE') || die();

/***************
 * Add default RTE configuration
 */
$GLOBALS['TYPO3_CONF_VARS']['RTE']['Presets']['stwm_sitepackage'] = 'EXT:stwm_sitepackage/Configuration/RTE/Default.yaml';


/***************
 * amds_bear
 */
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addUserTSConfig(
    '<INCLUDE_TYPOSCRIPT: source="FILE:EXT:stwm_sitepackage/Configuration/TSconfig/User.tsconfig">'
);

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addPageTSConfig(
    '<INCLUDE_TYPOSCRIPT: source="FILE:EXT:stwm_sitepackage/Configuration/PageTS/Mod/Wizards/NewContentElement.tsconfig">'
);


/***************
 * Register Icons
 */
$iconRegistry = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Core\Imaging\IconRegistry::class);

$iconsContentElements = [
    'alert',
    'hero',
    'menucard',
    'teaserbox',
    'ge-accordion',
    'ge-1col',
    'ge-2col',
    'ge-3col',
    'ge-4col',
    'ge-5col',
    'ge-flexbox'
];
foreach ($iconsContentElements as $icon) {
    $iconRegistry->registerIcon(
        'tx_stwm_' . $icon,
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:' . $_EXTKEY . '/Resources/Public/Icons/ContentElements/' . $icon . '.svg']
    );
}


$iconsBackendLayouts = [
    'default',
    'frontpage',
    'heroless',
    'jumbotron-sidebar-left',
    'jumbotron-sidebar-right',
    'sidebar-left',
    'sidebar-right',
];
foreach ($iconsBackendLayouts as $icon) {
    $iconRegistry->registerIcon(
        'tx_stwm_' . $icon,
        \TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider::class,
        ['source' => 'EXT:' . $_EXTKEY . '/Resources/Public/Icons/BackendLayouts/' . $icon . '.svg']
    );
}


$signalSlotDispatcher = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\SignalSlot\Dispatcher::class);
$signalSlotDispatcher->connect(\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::class, 'tcaIsBeingBuilt',  \AmadeusAgentur\Stwm_Sitepackage\Slots\TCAOverride::class, 'processData');

/***************
 * BE login window styling
 */

if (TYPO3_MODE === 'BE') {
    $signalSlotDispatcher = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance(\TYPO3\CMS\Extbase\SignalSlot\Dispatcher::class);

    /**
     * Add backend styling
     */
    $signalSlotDispatcher->connect(
        \TYPO3\CMS\Extensionmanager\Service\ExtensionManagementService::class,
        'hasInstalledExtensions',
        \AmadeusAgentur\Stwm_Sitepackage\Service\BrandingService::class,
        'setBackendStyling'
    );

}


// Add custom fields to Rootlinefields
$rootlinefields = &$GLOBALS["TYPO3_CONF_VARS"]["FE"]["addRootLineFields"];
if ($rootlinefields != '') {
    $rootlinefields .= ' , ';
}
$rootlinefields .= 'html_class';

/***************
 * Disable Deprecation Log on Production
 */

if(\TYPO3\CMS\Core\Utility\GeneralUtility::getApplicationContext()->isProduction()) {
    $GLOBALS['TYPO3_CONF_VARS']['LOG']['TYPO3']['CMS']['deprecations']['writerConfiguration'][\TYPO3\CMS\Core\Log\LogLevel::NOTICE] = [];
}
