var slideIndex = 0;
var heroSlider = document.getElementsByClassName('section-hero-slider');

if (!!heroSlider.length) {
    initSlides(slideIndex);
}


function initSlides(n) {
    createDots();
    showSlides(n)
}

function createDots() {
    var dotcontainer = document.getElementsByClassName('dot-container')[0];
    var slides = document.getElementsByClassName("hero");

    for (var index = 0; index < slides.length; index++) {
        var dot = document.createElement('div');

        dot.classList.add('dot');
        dot.setAttribute('data-id',index);
        dot.addEventListener('click', function (evt) {
            showSlides(evt.target.getAttribute('data-id'));
        });
        dotcontainer.appendChild(dot);
    }
}

var sliderTimeout;

function showSlides(n) {
    var i;
    var slides = document.getElementsByClassName("hero");

    for (i = 0; i < slides.length; i++) {
        // console.log(slideIndex, i, slides[i].classList);
        slides[i].style.display = "none";
    }

    slides[slideIndex].classList.remove("show");
    slides[slideIndex].style.display = "none";

    if (n == null) {
        slideIndex++;
    } else {
        slideIndex = n;
        clearTimeout(sliderTimeout);
    }

    if (slideIndex >= slides.length) {
        slideIndex = 0;
    }

    slides[slideIndex].style.display = "flex";
    slides[slideIndex].classList.add("fade");
    slides[slideIndex].classList.add("show");


    sliderTimeout = setTimeout(showSlides, 6000); // Change image every 2 seconds

}
