<?php
defined('TYPO3_MODE') || die();


/***************
 * Add Content Element
 */
if (!is_array($GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'])) {
    $GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'] = [];
}

/***************
 * Add content element to selector list
 */
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTcaSelectItem(
    'tt_content',
    'CType',
    [
        'LLL:EXT:stwm_sitepackage/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.wizard.title',
        'amdsbear_hero',
        'tx_amdsbear_hero'
    ],
    'textmedia',
    'after'
);

/***************
 * Assign Icon
 */
$GLOBALS['TCA']['tt_content']['ctrl']['typeicon_classes']['amdsbear_hero'] = 'tx_stwm_hero';


/***************
 * Register fields
 */
$tempColumns = [
    'tx_amdsbear_herosize' => [
        'label' => 'LLL:EXT:stwm_sitepackage/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize',
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                [
                    'LLL:EXT:stwm_sitepackage/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.normal',
                    'normal'
                ],
                [
                    'LLL:EXT:stwm_sitepackage/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.condensed',
                    'condensed'
                ],
                [
                    'LLL:EXT:stwm_sitepackage/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.expanded',
                    'expanded'
                ],
                [
                    'LLL:EXT:stwm_sitepackage/Resources/Private/Language/locallang_db.xlf:amdsbear_hero.tt_content.herosize.fullsize',
                    'fullsize'
                ],
            ],
        ],
    ],
];

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_content', $tempColumns);


/***************
 * Configure element type
 */

$GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'] = array_replace_recursive(

    $GLOBALS['TCA']['tt_content']['types']['amdsbear_hero'],
    [
        'showitem' => '
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
                    --palette--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:palette.general;general,header,subheader,tx_amdsbear_herosize,header_link,bodytext,image,
                --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.appearance,
                    --palette--;;frames,
                    --palette--;;appearanceLinks,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
                    --palette--;;language,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access,
                    --palette--;;hidden,
                    --palette--;;access,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:categories,
                    categories,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:notes,
                    rowDescription,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
            ',
        'columnsOverrides' =>
            [
                'bodytext' =>
                    [
                        'config' =>
                            [
                                'richtextConfiguration' => 'default',
                                'enableRichtext' => 1,
                            ],
                    ],
                'assets' =>
                    [
                        'config' =>
                            [
                                'maxitems' => '1',
                            ],
                    ]
            ],
    ]

);
