/* File: gulpfile.js */


// grab our gulp packages
var gulp = require('gulp'),
    del = require('del'),
    browser = require('browser-sync'),
    gulpif = require('gulp-if'),
    log = require('fancy-log'),
    autoprefixer = require('gulp-autoprefixer'),
    cleanCSS = require('gulp-clean-css'),
    sass = require('gulp-sass'),
    sourcemaps = require('gulp-sourcemaps'),
    webpack = require('webpack-stream');



var paths = {
    styles: {
        src: '../Resources/Public/Scss/',
        dest: '../Resources/Public/Css/'
    },
    scripts: {
        src: '../Resources/Public/JavaScript/Src/',
        dest: '../Resources/Public/JavaScript/Dist/'
    },
    images: '../Resources/Public/Images/'

};


// environmental settings for production/deployment

var $isProduction = (process.argv[3] == "--production"),
    $environment = (process.argv[4] == "--live" ? 'https://www.stadtwerke-meininge.de' : 'https://stwm.ddev.site');


var isProduction = false,
    sourceMap = true,
    deployDev = true,
    deployLive = false;

if ($isProduction) {
    isProduction = true;
    sourceMap = false;
    deployDev = true;
    deployLive = true;
}


function clean(done) {
    del([
        paths.styles.dest + '**/*',
        paths.scripts.dest + '**/*'
    ], {
        force: true
    });
    done();
}


// Less to CSS: Run manually with: "gulp build-css"
function stylesheet() {
    gulp.src([paths.styles.src + 'ie11.scss'])
        .pipe(gulpif(!$isProduction, sourcemaps.init()))
        .pipe(sass({
            includePaths: ['node_modules/']
        }).on('error', sass.logError))

        .pipe(gulpif($isProduction, autoprefixer({
            browserlist: ['>1% in DE']
        })))
        .pipe(gulpif($isProduction, cleanCSS({
                level: 1,
                format: (!$isProduction ? 'beautify' : 'none'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        )))
        .pipe(gulpif(!$isProduction, sourcemaps.write()))
        .pipe(gulp.dest(paths.styles.dest))


    return gulp.src([paths.styles.src + 'theme.scss'])
        .pipe(gulpif(!$isProduction, sourcemaps.init()))
        .pipe(sass({
            includePaths: ['node_modules/']
        }).on('error', sass.logError))

        .pipe(gulpif($isProduction, autoprefixer({
            browserlist: ['>1% in DE']
        })))
        .pipe(gulpif($isProduction, cleanCSS({
                level: 1,
                format: (!$isProduction ? 'beautify' : 'none'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        )))
        .pipe(gulpif(!$isProduction, sourcemaps.write()))
        .pipe(gulp.dest(paths.styles.dest))

        .pipe(browser.reload({stream: true}));
}


function jsLibs() {
    return gulp.src([
        'node_modules/jquery/dist/jquery.min.js',
        'node_modules/@fancyapps/fancybox/dist/jquery.fancybox.min.js',
        'node_modules/mmenu-light/dist/mmenu-light.js',
        'node_modules/headroom.js/dist/headroom.min.js',
        'node_modules/select2/dist/js/select2.min.js',
    ])
        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}

function cssLibs() {
    return gulp.src([
        'node_modules/@fancyapps/fancybox/dist/jquery.fancybox.min.css',
    ])
        .pipe(gulp.dest(paths.styles.dest)).on('error', function (err) {
            log(err);
        })
}

function jsBootstrap() {
    return gulp.src([
        'node_modules/bootstrap/js/dist/util.js',
        'node_modules/bootstrap/js/dist/alert.js',
        'node_modules/bootstrap/js/dist/collapse.js',
        'node_modules/bootstrap/js/dist/dropdown.js',
        'node_modules/bootstrap/js/dist/scrollspy.js',
        'node_modules/bootstrap/js/dist/tab.js',
        'node_modules/bootstrap/js/dist/popover.js',
        'node_modules/bootstrap/js/dist/modal.js',
        'node_modules/bootstrap/js/dist/tooltip.js',
        paths.scripts.src + 'scrolltop.js',
        paths.scripts.src + 'bootstrap.init.js',
        paths.scripts.src + 'headroom.init.js',
        paths.scripts.src + 'mmenu-light.init.js',
        paths.scripts.src + 'slider.init.js',
    ])
        .pipe(webpack(require('./webpack.config.js')))

        .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
            log(err);
        })
}



// function jsInit() {
//     return gulp.src(paths.scripts.src + '*.js')
//         .pipe(concat('init.js'))
//         .pipe(gulp.dest(paths.scripts.dest)).on('error', function (err) {
//             log(err);
//         })
// }


function server(done) {
    browser.init({
        open: false,
        online: true,
        reloadOnRestart: true,
        logConnections: true,
        proxy: $environment,
        https: true,
        serveStatic: [{
            route: ['typo3conf/ext/stwm_sitepackage/Resources/Public', 'typo3temp/assets/compressed'],
            dir: ['../Resources/Public/']
        }],
        notify: {
            styles: {
                top: 'auto',
                bottom: '0',
                borderRadius: '5px 0px 0px'
            }
        }
    });
    done();
}


function watch() {
    gulp.watch(paths.styles.src + '**/*.scss').on('all', gulp.series(stylesheet));
    gulp.watch(paths.scripts.src + '**/*.js').on('all', gulp.series(jsLibs, jsBootstrap, browser.reload));
}


// Build the "dist" folder by running all of the below tasks
gulp.task('build',
    gulp.series(clean, gulp.parallel(stylesheet, jsLibs, cssLibs, jsBootstrap))
);

// Build the site, run the server, and watch for file changes
gulp.task('default',
    gulp.series('build', server, watch)
);
