<?php
defined('TYPO3') or die();

/***************
 * New fields in table:tt_content
 */
$tempContentColumns = [

    'tx_amdsbear_header_position' => [
        'label' => 'Header Position',
        'exclude' => 1,
        'displayCond' => [
            'OR' => [
                'FIELD:CType:=:textmedia',
                'FIELD:CType:=:textpic',
            ],
        ],
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['Beside or under the image (default)', 'beside'],
                ['Above the image', 'above']
            ],
            'default' => 'beside'
        ]
    ],
    
    
    'tx_amdsbear_container' => [
        'label' => 'Container with full-fluid width',
        'exclude' => 1,
        'config' => [
            'type' => 'check',
            'items' => [
                ['add class "container-fluid"', '']
            ]
        ]
    ],
    'tx_amdsbear_context_classes' => [
        'label' => 'Context Classes',
        'exclude' => 1,
        'config' => [
            'type' => 'select',
            'renderType' => 'selectMultipleSideBySide',
            'items' => [
                ['primary', 'bg-primary'],
                ['secondary', 'bg-secondary'],
                ['light', 'bg-light'],
                ['dark', 'bg-dark'],
                
            ]
        ]
    ],
    'tx_amdsbear_extra_class' => [
        'label' => 'Extra HTML-Class',
        'exclude' => 1,
        'config' => [
            'type' => 'input',
            'eval' => 'trim',
            'size' => 255
        ]
    ],
    'tx_amdsbear_inTextImgRowWidth' => [
        'label' => 'Gallery row width in %',
        'exclude' => 1,
        'config' => [
            'type' => 'select',
            'renderType' => 'selectSingle',
            'items' => [
                ['auto', 'auto'],
                ['25 %', 'w-25'],
                ['33 %', 'w-33'],
                ['50 %', 'w-50'],
                ['66 %', 'w-66'],
                ['75 %', 'w-75'],
                ['none', 'none']
            ],
            'default' => 'auto'
        ]
    ],

];

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('tt_content', $tempContentColumns);
unset($tempContentColumns);
