<?php

namespace AmadeusAgentur\Stwm_Sitepackage\Service;

use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * BrandingService
 */
class BrandingService
{
    /**
     * @var string
     */
    const EXT_KEY = 'stwm_sitepackage';

    /**
     * @param string $extension
     */
    public function setBackendStyling($extension = null)
    {
        if ($extension === self::EXT_KEY && class_exists(ExtensionConfiguration::class)) {
            $extensionConfiguration = GeneralUtility::makeInstance(
                ExtensionConfiguration::class
            );
            $backendConfiguration = $extensionConfiguration->get('backend');


            if (!isset($backendConfiguration['loginLogo']) || empty(trim($backendConfiguration['loginLogo']))) {
                $backendConfiguration['loginLogo'] = 'EXT:' . self::EXT_KEY . '/Resources/Public/Images/Backend/login-logo.svg';
            }
            if (!isset($backendConfiguration['loginBackgroundImage']) || empty(trim($backendConfiguration['loginBackgroundImage']))) {
                $backendConfiguration['loginBackgroundImage'] = 'https://source.unsplash.com/collection/915992/1600x900';
            }
            if (!isset($backendConfiguration['loginHighlightColor']) || empty(trim($backendConfiguration['loginHighlightColor']))) {
                $backendConfiguration['loginHighlightColor'] = '#009999';
            }

            if (!isset($backendConfiguration['loginFootnote']) || empty(trim($backendConfiguration['loginFootnote']))) {
                $backendConfiguration['loginFootnote'] = 'www.amadeus-agentur.com';
            }

            $extensionConfiguration->set('backend', '', $backendConfiguration);
        }
    }
}
