const Browser = require('browser-sync');

const Server = {
    init: (done) => {
        Browser.init({
            open: false,
            online: true,
            reloadOnRestart: true,
            logConnections: true,

            proxy: global.config.proxyUrl[process.env.NODE_ENV],

            https: true,
            serveStatic: [{
                route: ['typo3conf/ext/'+global.config.themeName+'/Resources/Public', 'typo3temp/assets/compressed'],
                dir: [global.config.path.basePath.static]
            }],
            notify: {
                styles: {
                    top: 'auto',
                    bottom: '0',
                    borderRadius: '3px 0px 0px'
                }
            }
        });
        done();
    }
};


exports.Server = Server;