exports.Utils = {
    selectCSS: () => {
        switch (global.config.cssPreProcessor) {
            case "scss":
                return require('./scss');
                break;
            case "less":
                return require('./less');
                break;
            default:
                throw 'Missing cssPreProcessor in config';
        }
    },
    getPath: () => {
        switch (global.config.projectType) {
            case "typo3":
                return require("./_basepath.typo3");
                break;
            case "wordpress":
                return require("./_basepath.wordpress");
                break;
            default:
                throw "No projectType in Config";
        }
    },
    capitalize : (s) => {
        if (typeof s !== 'string') return '';
        return s.charAt(0).toUpperCase() + s.slice(1)
    }
};
