function initialize() {

    var newLocations = [];
    
    var mapDiv = document.getElementById('map-canvas');

    var myMapOptions = {

        zoom: 7,
        scrollwheel: false,
        navigationControl: false,
        panControl: false,
        mapTypeControl: false,
        scaleControl: false,
        draggable: true,
        zoomControlOptions: {
            style: google.maps.ZoomControlStyle.LARGE,
            position: google.maps.ControlPosition.RIGHT_CENTER
        },
        streetViewControl: false,

        styles: [
            {
                "featureType": "administrative.country",
                "elementType": "labels",
                "stylers": [
                    {
                        "saturation": -100
                    },
                    {
                        "gamma": 3.6
                    }
                ]
            },
            {
                "featureType": "administrative.locality",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "simplified"
                    },
                    {
                        "lightness": "25"
                    },
                    {
                        "saturation": "-100"
                    },
                    {
                        "gamma": "1"
                    }
                ]
            },
            {
                "featureType": "landscape",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": "-100"
                    },
                    {
                        "lightness": "0"
                    },
                    {
                        "gamma": "2.86"
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "road",
                "elementType": "all",
                "stylers": [
                    {
                        "saturation": "-100"
                    },
                    {
                        "visibility": "simplified"
                    }
                ]
            },
            {
                "featureType": "road",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "transit",
                "elementType": "all",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "saturation": "-100"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "all",
                "stylers": [
                    {
                        "saturation": "-100"
                    },
                    {
                        "visibility": "simplified"
                    }
                ]
            },
            {
                "featureType": "water",
                "elementType": "labels",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            }
        ]
    };

    var map = new google.maps.Map(mapDiv, myMapOptions);


    // Marker für locations setzen und info window aufbauen

    var infowindow = new google.maps.InfoWindow({
        maxWidth: 300
    });

    var markers = new Array();

    for (var i = 0; i < locations.length; i++) {
        var marker = new google.maps.Marker({
            position: new google.maps.LatLng(locations[i][1], locations[i][2]),
            map: map,
            title: locations[i][0],
            icon: 'https://www.seralea.de/fileadmin/templates/seralea/Resources/Public/Maps/marker-1.svg'
        });

        markers.push(marker);


        google.maps.event.addListener(marker, 'click', (function (marker, i) {
            var infoWindowContent = '<div class="klinik1"><strong>' + locations[i][0] + '</strong></div><div class="adresse">' + locations[i][3] + '<br>' + locations[i][4] + '</div>'
            return function () {
                infowindow.setContent(infoWindowContent);
                infowindow.open(map, marker);
            }
        })(marker, i));

    }



    var markerClusterer = new MarkerClusterer(
        map,
        markers, {
            gridSize: 20,
            minimumClusterSize: 2,
            maxZoom: 12,
            zoomOnClick: false,
            // averageCenter: false,

            styles: [{
                url: 'https://www.serag-wiessner.de/fileadmin/templates/seralea/Resources/Public/Maps/marker-1.svg',
                height: 36,
                width: 26,
                textColor: 'transparent',
                textSize: 10
            }, {
                url: 'https://www.serag-wiessner.de/fileadmin/templates/seralea/Resources/Public/Maps/marker-2.svg',
                height: 40.15,
                width: 34.48,
                textColor: 'transparent',
                iconAnchor: [17,40]
            }, {
                url: 'https://www.serag-wiessner.de/fileadmin/templates/seralea/Resources/Public/Maps/marker-3.svg',
                height: 43.65,
                width: 42,
                textColor: 'transparent',
                iconAnchor: [21,33]
            }, {
                url: 'https://www.serag-wiessner.de/fileadmin/templates/seralea/Resources/Public/Maps/marker-4.svg',
                height: 54.15,
                width: 54,
                textColor: 'transparent',
                iconAnchor: [27,44]
            }, {
                url: 'https://www.serag-wiessner.de/fileadmin/templates/seralea/Resources/Public/Maps/marker-5.svg',
                height: 63.5,
                width: 57,
                textColor: 'transparent',
                iconAnchor: [28,53]
            }],

        }
    );

    markerClusterer.setCalculator(
        function(markers, numStyles) {
            var count = markers.length;

            return {
                text: count,
                index: count
            };
        }

    );

    function autoCenter() {
        //  Create a new viewpoint bound
        var bounds = new google.maps.LatLngBounds();
        //  Go through each...
        for (var i = 0; i < markers.length; i++) {
            bounds.extend(markers[i].position);
        }
        //  Fit these bounds to the map
        map.fitBounds(bounds);

        google.maps.event.addListenerOnce(map, 'bounds_changed', function (event) {
            this.setZoom(6);
            if (window.innerWidth > '720') {
                map.panBy(-200, 0);
            }
        });
    }

    autoCenter();

    google.maps.event.addListener(markerClusterer, 'clusterclick', function (cluster) {
        map.setCenter(cluster.getCenter());
        map.setZoom(map.getZoom() + 2);
    });

}


google.maps.event.addDomListener(window, 'load', initialize);


$(window).on('resize', function () {
    google.maps.event.trigger(map, "resize");
})

