<?php

if ( ! class_exists( 'Timber' ) ) {
    echo 'Timber not activated. Make sure you activate the plugin in <a href="/wp-admin/plugins.php#timber">/wp-admin/plugins.php</a>';

    return;
}

$context            = Timber::context();
$context['sidebar'] = Timber::get_widgets( 'shop-sidebar' );

if ( is_singular( 'product' ) ) {
    $context['post']    = Timber::get_post();

    if (isset($context['post']->combo_products)) {
        if ($context['post']->combo_products != '') {
            $combo_posts = array();
            $i = 0;

            foreach ($context['post']->combo_products as $combo) {
                $combo_posts[$i] = Timber::get_post(intval($combo));
                $i++;
            }

            $context['post']->combo_products = $combo_posts;
        }
    }

    $product            = wc_get_product( $context['post']->ID );
    $context['product'] = $product;

    $context['post_cat'] = get_the_terms( $context['post']->ID, 'product_cat' );

    // Get related products
    $related_limit               = wc_get_loop_prop( 'columns' );
    $related_ids                 = wc_get_related_products( $context['post']->id, $related_limit );
    $context['related_products'] =  Timber::get_posts( $related_ids );

    // Restore the context and loop back to the main query loop.
    wp_reset_postdata();

    Timber::render( 'templates/woo/single-product.twig', $context );
} else {
    $posts = Timber::get_posts();
    $context['products'] = $posts;

    if ( is_product_category() ) {
        $queried_object = get_queried_object();
        $term_id = $queried_object->term_id;
        $context['category'] = get_term( $term_id, 'product_cat' );
        $context['title'] = single_term_title( '', false );
    }

    Timber::render( 'templates/woo/archive.twig', $context );
}