(function (window, document) {

    // we fetch the elements each time because docusaurus removes the previous
    // element references on page navigation
    function getElements() {
        return {
            layout: document.getElementById('menu-target'),
            menu: document.getElementById('menu'),
            menuLink: document.getElementById('menuLink')
        };
    }

    function toggleClass(element, className) {
        var classes = element.className.split(/\s+/);
        var length = classes.length;
        var i = 0;

        for (; i < length; i++) {
            if (classes[i] === className) {
                classes.splice(i, 1);
                break;
            }
        }
        // The className is not found
        if (length === classes.length) {
            classes.push(className);
        }

        element.className = classes.join(' ');
    }

    function toggleAll() {
        var active = 'active';
        var elements = getElements();

        toggleClass(elements.layout, active);
        toggleClass(elements.menu, active);
        document.getElementById('menuLink').classList.toggle("is-active");
    }

    function handleEvent(e) {
        var elements = getElements();

        //alert(e.target.id);
        if (e.target.id === elements.menuLink.id) {
            document.getElementsByTagName('body')[0].classList.toggle("menu-active");
            document.getElementById('menu-target').classList.toggle("active");
            document.getElementById('menu').classList.toggle("active");
            document.getElementById('menuLink').classList.toggle("is-active");
            e.preventDefault();
        } else if (elements.menu.className.indexOf('active') !== -1) {
            toggleAll();
        }
    }

    document.addEventListener('click', handleEvent);

}(this, this.document));


(function (window, document) {

    // we fetch the elements each time because docusaurus removes the previous
    // element references on page navigation
    function getElements() {
        return {
            ftoggle: document.getElementById('filter-toggle'),
            filter: document.getElementById('filterbar')
        };
    }

    function handleEvent(e) {
        var elements = getElements();

        if (elements.ftoggle != null) {
            //alert(e.target.id);
            if (e.target.id === 'filter-toggle') {
                elements.ftoggle.classList.toggle("active");
                elements.filter.classList.toggle("is-active");
                e.preventDefault();
            }

            if (elements.ftoggle.className.indexOf('active') !== -1) {
                if (document.documentElement.lang === 'de-DE') {
                    elements.ftoggle.innerHTML = "Filter ausblenden";
                } else {
                    elements.ftoggle.innerHTML = "Hide filter section";
                }
            } else {
                if (document.documentElement.lang === 'de-DE') {
                    elements.ftoggle.innerHTML = "Filter anzeigen";
                } else {
                    elements.ftoggle.innerHTML = "Show filter section";
                }
            }
        }
    }

    document.addEventListener('click', handleEvent);

}(this, this.document));


let totop = document.getElementById('scroll-top-wrapper');
let modal = document.getElementById('request-modal');
let requestForm = document.getElementById('evf-form-1056');

window.onscroll = function() {scrollFunction()};

if ( modal != null && requestForm != null ) {
    document.getElementById('modal-opener').addEventListener('click', openModal);
    document.getElementById('evf-form-1056').addEventListener('submit', closeModal);
    document.getElementById('modal-closer').addEventListener('click', closeModal);

    function openModal() {
        document.getElementById('evf-form-1056').removeAttribute('novalidate');
        document.getElementsByTagName('body')[0].classList.toggle('has-modal');
        modal.classList.toggle('active');
    }

    function closeModal(event) {
        modal.classList.toggle('active');
        document.getElementsByTagName('body')[0].classList.toggle('has-modal');
        event.preventDefault();
    }
}

function scrollFunction() {
    if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
        totop.style.opacity = "1";
    } else {
        let transparency = document.documentElement.scrollTop / 200;
        totop.style.opacity = transparency.toString();
    }
}

function topFunction() {
    document.body.scrollTop = 0; // For Safari
    document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
}

totop.addEventListener('click', topFunction);

var elms = document.getElementsByClassName( 'splide' );

for ( var i = 0; i < elms.length; i++ ) {
    new Splide( elms[ i ] ).mount();
}