<?php
/**
 * Timber starter-theme
 * https://github.com/timber/starter-theme
 *
 * @package  WordPress
 * @subpackage  Timber
 * @since   Timber 0.1
 */

/**
 * If you are installing Timber as a Composer dependency in your theme, you'll need this block
 * to load your dependencies and initialize Timber. If you are using Timber via the WordPress.org
 * plug-in, you can safely delete this block.
 */
$composer_autoload = __DIR__ . '/vendor/autoload.php';
if ( file_exists( $composer_autoload ) ) {
	require_once $composer_autoload;
	$timber = new Timber\Timber();
}

/**
 * This ensures that Timber is loaded and available as a PHP class.
 * If not, it gives an error message to help direct developers on where to activate
 */
if ( ! class_exists( 'Timber' ) ) {

	add_action(
		'admin_notices',
		function() {
			echo '<div class="error"><p>Timber not activated. Make sure you activate the plugin in <a href="' . esc_url( admin_url( 'plugins.php#timber' ) ) . '">' . esc_url( admin_url( 'plugins.php' ) ) . '</a></p></div>';
		}
	);

	add_filter(
		'template_include',
		function( $template ) {
			return get_stylesheet_directory() . '/static/no-timber.html';
		}
	);
	return;
}

/**
 * Sets the directories (inside your theme) to find .twig files
 */
Timber::$dirname = array( 'templates', 'views' );

/**
 * By default, Timber does NOT autoescape values. Want to enable Twig's autoescape?
 * No prob! Just set this value to true
 */
Timber::$autoescape = false;


/**
 * We're going to configure our theme inside of a subclass of Timber\Site
 * You can move this to its own file and include here via php's include("MySite.php")
 */
class StarterSite extends Timber\Site {
	/** Add timber support. */
	public function __construct() {
		add_action( 'after_setup_theme', array( $this, 'theme_supports' ) );
		add_filter( 'timber/context', array( $this, 'add_to_context' ) );
		add_filter( 'timber/twig', array( $this, 'add_to_twig' ) );
		add_action( 'init', array( $this, 'register_post_types' ) );
		add_action( 'init', array( $this, 'register_taxonomies' ) );
        // add_action( 'init', array( $this, 'register_acf_blocks'), 5 );
        add_action( 'acf/init', array( $this, 'my_acf_init') );
        add_action( 'wp_enqueue_scripts', [$this, 'registerScripts'], 1, 1);
        add_action( 'wp_enqueue_scripts', [$this, 'registerStyles'], 2, 13);
        add_action( 'wp_enqueue_scripts', [$this, 'deregisterStyles'], 999, 0);

        add_action( 'widgets_init', [$this, 'gramss_widgets_init'] );
        add_action( 'after_setup_theme', array( $this, 'theme_add_woocommerce_support' ) );

        add_filter( 'loop_shop_per_page', array( $this, 'new_loop_shop_per_page'), 20 );
        add_filter( 'the_title', array( $this, 'shorten_woo_product_title'), 10, 2 );

        //remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail' );

		parent::__construct();
	}

    public function registerStyles() {
        wp_enqueue_style($this->themeSlug . '-style', get_theme_root_uri() . DIRECTORY_SEPARATOR . 'gramss-next/static/css/theme.css', ['wp-block-library'],
            wp_get_theme()->get('Version'));
    }

    public function registerScripts() {
        wp_enqueue_script('splide', get_theme_root_uri() . DIRECTORY_SEPARATOR . 'gramss-next/static/js/vendor/splide.min.js', [],
            wp_get_theme()->get('Version'), true);
        wp_enqueue_script('app', get_theme_root_uri() . DIRECTORY_SEPARATOR . 'gramss-next/static/js/app.init.js', [],
            wp_get_theme()->get('Version'), true);
    }

    public function deregisterScripts()
    {
        wp_dequeue_script('wp_editor');
    }

	/** This is where you can register custom post types. */
	public function register_post_types() {

	}
	/** This is where you can register custom taxonomies. */
	public function register_taxonomies() {

	}

	/** This is where you add some context
	 *
	 * @param string $context context['this'] Being the Twig's {{ this }}.
	 */
	public function add_to_context( $context ) {
        $context['footer_widget'] = Timber::get_widgets( 'footer_widget_1' );
        $context['social_links'] = Timber::get_widgets( 'footer_widget_2' );
		$context['primary']  = new Timber\Menu( 'primary' );
        $context['primary_en']  = new Timber\Menu( 'primary_en' );
		$context['footer']  = new Timber\Menu( 'footer' );
        $context['footer_en']  = new Timber\Menu( 'footer_en' );
		return $context;
	}

	public function theme_supports() {
		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
			)
		);

		/*
		 * Enable support for Post Formats.
		 *
		 * See: https://codex.wordpress.org/Post_Formats
		 */
		add_theme_support(
			'post-formats',
			array(
				'aside',
				'image',
				'video',
				'quote',
				'link',
				'gallery',
				'audio',
			)
		);

		add_theme_support( 'menus' );
        add_theme_support( 'widgets' );
	}

    public function theme_add_woocommerce_support() {
        add_theme_support( 'woocommerce' );
    }

	/** This is where you can add your own functions to twig.
	 *
	 * @param string $twig get extension.
	 */
	public function add_to_twig( $twig ) {
		$twig->addExtension( new Twig\Extension\StringLoaderExtension() );
		$twig->addFilter( new Twig\TwigFilter( 'myfoo', array( $this, 'myfoo' ) ) );
		return $twig;
	}

    public function gramss_widgets_init() {
        register_sidebar( array(
            'name' => 'Footer Widget',
            'id' => 'footer_widget_1',
            'before_widget' => '<div>',
            'after_widget' => '</div>',
            'before_title' => '<!-- Widget: ',
            'after_title' => ' -->', ) );

        register_sidebar( array(
            'name' => 'Social Links',
            'id' => 'footer_widget_2',
            'before_widget' => '<div>',
            'after_widget' => '</div>',
            'before_title' => '<!-- Widget: ',
            'after_title' => ' -->', ) );
    }

    public function register_acf_blocks() {
        // The ACF 6 way of life (doesn't work) - findet die Callback-Funktion nich...
        register_block_type( __DIR__ . '/blocks/splide' );
    }

    function my_acf_init() {
        // The ACF 5 way of life (works)
        if ( ! function_exists( 'acf_register_block' ) ) {
            return;
        }

        // Register a new block.
        acf_register_block( array(
            'name'            => 'splide',
            'title'           => 'Splide Slide',
            'description'     => 'A Splide-based image slider',
            'render_callback' => array($this, 'acf_splide'),
            'category'        => 'formatting',
            'icon'            => 'images-alt2',
            'keywords'        => array( 'example' ),
        ) );
    }

    public function acf_splide( $block, $content = '', $is_preview = false) {
        $context = Timber::context();

        // Store block values.
        $context['block'] = $block;

        // Store field values.
        $context['fields'] = get_fields();

        // Store $is_preview value.
        $context['is_preview'] = $is_preview;

        // Render the block.
        Timber::render( 'partials/block/splide.twig', $context );
    }

    /**
     * Change number of products that are displayed per page (shop page)
     */
    public function new_loop_shop_per_page( $cols ) {
        // $cols contains the current number of products per page based on the value stored on Options –> Reading
        // Return the number of products you wanna show per page.
        $cols = 15;
        return $cols;
    }

    public function shorten_woo_product_title( $title, $id ) {
        if ( ! is_singular( array( 'product' ) ) && get_post_type( $id ) === 'product' && strlen( $title ) > 75 ) {
            return substr( $title, 0, 75) . '…'; // change last number to the number of characters you want
        } else {
            return $title;
        }
    }
}

new StarterSite();
