<?php
/**
 * @package    Grav.Common
 *
 * @copyright  Copyright (C) 2014 - 2016 RocketTheme, LLC. All rights reserved.
 * @license    MIT License; see LICENSE file for details.
 */

namespace Grav\Common;

use RocketTheme\Toolbox\Session\Session as BaseSession;

class Session extends BaseSession
{
    protected $grav;
    protected $session;

    /**
     * Session constructor.
     *
     * @param Grav $grav
     */
    public function __construct(Grav $grav)
    {
        $this->grav = $grav;
    }

    /**
     * Session init
     */
    public function init()
    {
        /** @var Uri $uri */
        $uri = $this->grav['uri'];
        $config = $this->grav['config'];

        $is_admin = false;
        $base_url = $uri->rootUrl(false);

        $session_timeout = $config->get('system.session.timeout', 1800);
        $session_path = $config->get('system.session.path', '/' . ltrim($base_url, '/'));

        // Activate admin if we're inside the admin path.
        if ($config->get('plugins.admin.enabled')) {
            $route = $config->get('plugins.admin.route');
            // Uri::route() is not processed yet, let's quickly get what we need
            $current_route = str_replace($base_url, '', parse_url($uri->url(true), PHP_URL_PATH));
            $base = '/' . trim($route, '/');

            if (substr($current_route, 0, strlen($base)) == $base || //handle no language specified
                substr($current_route, 3, strlen($base)) == $base || //handle language (en)
                substr($current_route, 6, strlen($base)) == $base) { //handle region specific language prefix (en-US)
                $session_timeout = $config->get('plugins.admin.session.timeout', 1800);
                $is_admin = true;
            }
        }

        if ($config->get('system.session.enabled') || $is_admin) {
            // Define session service.
            parent::__construct($session_timeout, $session_path);

            $domain = $uri->host();
            if ($domain === 'localhost') {
                $domain = '';
            }
            $secure = $config->get('system.session.secure', false);
            $httponly = $config->get('system.session.httponly', true);

            $unique_identifier = GRAV_ROOT;
            $inflector = new Inflector();
            $this->setName($inflector->hyphenize($config->get('system.session.name', 'grav_site')) . '-' . substr(md5($unique_identifier), 0, 7) . ($is_admin ? '-admin' : ''));
            $this->start();
            setcookie(session_name(), session_id(), time() + $session_timeout, $session_path, $domain, $secure, $httponly);
        }
    }

    // Store something in session temporarily
    public function setFlashObject($name, $object)
    {
        $this->$name = serialize($object);
    }

    // Return object and remove it from session
    public function getFlashObject($name)
    {
        $object = unserialize($this->$name);

        $this->$name = null;

        return $object;
    }
}
