<?php
defined('TYPO3_MODE') || die();

call_user_func(function()
{
    /**
     * Temporary variables
     */
    $extensionKey = 'cc_sitepackage';

    /**
     * Default PageTS for Sitepackage
     */
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::registerPageTSConfigFile(
        $extensionKey,
        'Configuration/TSConfig/Page/All.tsconfig',
        'colorfulchairs - TSconfig'
    );
});


// Configure new fields:
$fields = array(
    'page_color' => array(
        'label' => 'Page Main Color',
        'exclude' => 1,
        'config' => array(
            'type' => 'select',
            'eval' => 'trim,nospace',
            'renderType' => 'selectSingle',
            'items' => [
                ['default', 'default'],
                ['none', 'none']
            ],
            'default' => ''
        ),
    )
);



// Add new fields to pages:
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('pages', $fields);


// Make fields visible in the TCEforms:
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes(
    'pages', // Table name
    '--palette--;Darstellung;cc_sitepackage', // Field list to add
    '', // List of specific types to add the field list to. (If empty, all type entries are affected)
    'after:layout' // Insert fields before (default) or after one, or replace a field
);

// Add the new palette:
$GLOBALS['TCA']['pages']['palettes']['cc_sitepackage'] = array(
    'showitem' => 'page_color'
);
