<?php

namespace AmadeusAgentur\Nahrstedt\Sitepackage\ViewHelpers;

use AmadeusAgentur\Nahrstedt\Sitepackage\Domain\Model\Address;
use TYPO3\CMS\Core\Resource\ResourceFactory;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class AddressSalesViewHelper extends AbstractViewHelper
{
    
    
    protected $escapeOutput = false;
    
    public function initializeArguments()
    {
        parent::initializeArguments();
        
        $this->registerArgument('address', Address::class, 'Adressdatensatz', true);
    }
    
    
    public function render()
    {
        $sales = $this->arguments['address']->getSales();
        if ($sales != NULL && $sales > 0) {
            
            
            $resourceFactory = ResourceFactory::getInstance();
            $fileCollection = $resourceFactory->getCollectionObject($sales);
            $fileCollection->loadContents();
            
            $r = '';
            
            $KW = 'KW' . date("W") . '.pdf';
            $KWnext = 'KW' . date("W", strtotime("next Week")) . '.pdf';
            
            foreach ($fileCollection as $file) {
                if (substr($file->getName(), -strlen($KW)) === $KW) {
                    $r .= '<a href="' . $file->getPublicUrl() . '" class=current>aktuelle Woche</a>';
                }
                
                if (substr($file->getName(), -strlen($KWnext)) === $KWnext) {
                    $r .= '<a href="' . $file->getPublicUrl() . '" class=next>kommende Woche</a>';
                }
            }
            if ($r == "") $r = "<p>Leider noch keine Angebote vorhanden</p>";
            return $r;
        }
    }
}

