<?php

namespace AmadeusAgentur\Nahrstedt\Sitepackage\ViewHelpers;

use AmadeusAgentur\Nahrstedt\Sitepackage\Domain\Model\Address;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class AddressOpeningHoursViewHelper extends AbstractViewHelper
{




    public function initializeArguments()
    {
        parent::initializeArguments();

        $this->registerArgument('address', Address::class, 'Adressdatensatz', true);
    }


    public function render()
    {
        $openingHours = $this->arguments['address']->getOpeningHours(true);

        $r = "heute geschlossen";

        $dayOfWeek = date('N') - 1;

        if($openingHours[$dayOfWeek][1] != "geschlossen")
        {
            $r = 'heute geöffnet von '.strftime("%R", strtotime($openingHours[$dayOfWeek][1])) .' bis '. strftime("%R", strtotime($openingHours[$dayOfWeek][2])).' Uhr';
        }

        return $r;
//
//
//        if ($this->arguments['address']->getSales() > 0) {
//            return $this->renderThenChild();
//        }
//
//        return $this->renderElseChild();

    }
}