<?php

namespace AmadeusAgentur\Nahrstedt\Sitepackage\Domain\Model;

use FriendsOfTYPO3\TtAddress\Domain\Model\Address as TTAddress;


/**
 *  EXTENDING TT_ADDRESS
 * @package AmadeusAgentur\Nahrstedt\Sitepackage\Domain\Model
 *
 * */
class Address extends TTAddress
{
    /**
     * @var string
     */
    protected $openingHours = '';
    
    /**
     * @var string
     */
    protected $sales;
    
    /**
     * @return mixed
     */
    public function getSales(): string
    {
        return $this->sales;
    }
    
    /**
     * @param mixed $sales
     */
    public function setSales($sales): void
    {
        $this->sales = $sales;
    }
    
    /**
     * @param bool $raw
     * @return mixed
     */
    public function getOpeningHours($raw = false)
    {
        
        if ($raw) return $this->getRawOpenings();
        
        $tmp = str_getcsv($this->openingHours, "\n");
        
        $r = '<table class="table table-condensed">';
        
        foreach ($tmp as $line) {
            $r .= '<tr itemprop="openingHoursSpecification" itemtype="http://schema.org/OpeningHoursSpecification" itemscope>';
            
            $openings = str_getcsv($line, "|");
            
            $r .= '<th itemprop="dayOfWeek">' . $openings[0] . '</th>';
            
            $r .= '<td itemprop="opens" content="' . ($openings[1] ? strftime("%R", strtotime($openings[1])) : '') . '">' . ($openings[1] ? strftime("%R", strtotime($openings[1])) : 'geschlossen') . '</td>';
            
            $r .= '<td itemprop="closes" content="' . ($openings[2] ? strftime("%R", strtotime($openings[2])) : '') . '">' . ($openings[2] ? strftime("%R", strtotime($openings[2])) : '') . '</td>';
            
            if (isset($openings[3])) {
                $r .= '<td>' . $openings[3] . '</td>';
            }
            
            $r .= '</tr>';
        }
        
        
        $r .= '</table>';
        
        return $r;
    }
    
    
    /**
     * @param string $openingHours
     */
    public function setOpeningHours($openingHours): void
    {
        $this->openingHours = $openingHours;
    }
    
    private function getRawOpenings()
    {
        $tmp = str_getcsv($this->openingHours, "\n");
        $r = [];
        foreach ($tmp as $line) {
            $r[] = str_getcsv($line, "|");
        }
        
        return $r;
    }
}
