(function () {
    // grab an element
    let navbar = document.querySelector(".navbar-main");
    // construct an instance of Headroom, passing the element


    let options = {
        // vertical offset in px before element is first unpinned
        offset: window.innerHeight/3,
        // scroll tolerance in px before state changes
        // or you can specify tolerance individually for up/down scroll
        tolerance: {
            up: window.innerHeight/25,
            down: window.innerHeight/25
        },
        // css classes to apply
        classes: {
            // when element is initialised
            initial: 'is--sticky',
            // when scrolling up
            pinned: "is--pinned",
            // when scrolling down
            unpinned: "is--unpinned",
            // when above offset
            top: "is--top",
            // when below offset
            notTop: "is--not-top",
            // when at bottom of scoll area
            bottom: "is--bottom",
            // when not at bottom of scroll area
            notBottom: "is--not-bottom"
        }
    };

    let headroom = new Headroom(navbar, options);

    // initialise
    headroom.init();

})();
