/* Detects which OS is used and if it's a iOS or Android device it replaces the href to social networks according apps (e. g. <a … data-applink="fb://…") */

(function () {

    let OSName = "Unknown OS";
    if (navigator.appVersion.indexOf("Win") !== -1) OSName = "Windows";
    if (navigator.appVersion.indexOf("Mac") !== -1) OSName = "MacOS";
    if (navigator.appVersion.indexOf("iPhone") !== -1) OSName = "iOS";
    if (navigator.appVersion.indexOf("iPad") !== -1) OSName = "iOS";
    if (navigator.appVersion.indexOf("Android") !== -1) OSName = "Android";


    if (OSName === "iOS" || OSName === "Android") {
        let applinks = document.querySelectorAll("[data-applink]");
        for (i = 0; i < applinks.length; i++) {
            console.log(applinks[i] + ', ' +  applinks[i].dataset.applink);
            applinks[i].setAttribute('href', applinks[i].dataset.applink)
        }
    }

}());
