<?php
namespace Nahrstedt\Sitepackage\Service;

use TYPO3\CMS\Core\Configuration\ExtensionConfiguration;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use AmadeusAgentur\Bear\Service\BrandingService as BrandingServiceParent;

/**
* BrandingService
*/
class BrandingService extends BrandingServiceParent
{
    /**
    * @var string
    */
    const EXT_KEY = 'bn_sitepackage';


    /**
     * @param string $extension
     */
    public function setBackendStyling($extension = null)
    {
        if ($extension === self::EXT_KEY && class_exists(ExtensionConfiguration::class)) {
            $extensionConfiguration = GeneralUtility::makeInstance(
                ExtensionConfiguration::class
            );
            $backendConfiguration = $extensionConfiguration->get('backend');


            if (!isset($backendConfiguration['loginLogo']) || empty(trim($backendConfiguration['loginLogo']))) {
                $backendConfiguration['loginLogo'] = 'EXT:' . self::EXT_KEY . '/Resources/Public/Images/Backend/login-logo.svg';
            }
            if (!isset($backendConfiguration['loginBackgroundImage']) || empty(trim($backendConfiguration['loginBackgroundImage']))) {
                $backendConfiguration['loginBackgroundImage'] = 'EXT:' . self::EXT_KEY . '/Resources/Public/Images/Backend/login-background-image.jpg';
            }
            if (!isset($backendConfiguration['loginHighlightColor']) || empty(trim($backendConfiguration['loginHighlightColor']))) {
                $backendConfiguration['loginHighlightColor'] = '#b61c3e';
            }

            if (!isset($backendConfiguration['loginFootnote']) || empty(trim($backendConfiguration['loginFootnote']))) {
                $backendConfiguration['loginFootnote'] = 'www.amadeus-agentur.com';
            }

            $extensionConfiguration->set('backend', '', $backendConfiguration);
        }
    }
}
