<html lang="<?php echo $_GET['lang'] ?>">
<head>
    <meta charset="UTF-8">
    <link rel="stylesheet" href="/typo3conf/ext/seragwiessner_sitepackage/Resources/Public/Css/theme.css">
</head>
<body class="body-showroom">
<div class="app app-nadelshowroom">
    <div class="viewer-startscreen">
        <div class="showroomhint">
            <span>[[chooseNeedle_big]]</span>
        </div>
    </div>

    <div class="viewer viewer-a">
        <iframe src="" id="viewer-a-frame" allow="autoplay; fullscreen; vr" allowvr allowfullscreen
                sandbox="allow-scripts allow-same-origin allow-popups allow-forms"
                mozallowfullscreen="true" webkitallowfullscreen="true"
                width="640" height="480" data-active-sketchfabid=""></iframe>
        <div class="model-selection model-selection-a">
            <div class="dropdown">
                <button class="btn btn-primary" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="icon icon-down-open"></span>
                </button>

                <ul class="dropdown-menu nav-needles">
                    <li data-needle-type="DRN" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartR nadmerkN"
                        data-sketchfabid="fba84af4b7ec48189933ca73326bd122">
                        DRN
                    </li>
                    <li data-needle-type="DRT" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartR nadmerkT"
                        data-sketchfabid="5688320311e643cd835df1f34f385475">
                        DRT
                    </li>
                    <li data-needle-type="DRM" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartR nadmerkM"
                        data-sketchfabid="75dea4842bd54dc790d972c096a48f32">
                        DRM
                    </li>
                    <li data-needle-type="DSS" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS nadmerkS"
                        data-sketchfabid="ab930ba2fd8d4b289beb268fa403019b">
                        DSS
                    </li>
                    <li data-needle-type="DSL" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS nadmerkL"
                        data-sketchfabid="ec3e5f7ca3f144169d48d45fc06f5581">
                        DSL
                    </li>
                    <li data-needle-type="DSLA" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadmerkA nadartS nadmerkL"
                        data-sketchfabid="751f81a67c1f4c1b86bf5bd12337aa2f">
                        DSLA
                    </li>
                    <li data-needle-type="DS" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS"
                        data-sketchfabid="88499d1e2478417d85aed915afdec95d">
                        DS
                    </li>
                    <li data-needle-type="DSX" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS nadmerkX"
                        data-sketchfabid="5b33a20669494b35934b78eb833c4c41">
                        DSX
                    </li>
                    <li data-needle-type="FRN" class="nadelsymbol needle-selector"
                        data-original-title="nadformF nadartR nadmerkN"
                        data-sketchfabid="d4b8cfce6f844d48a3f75179edd7bd41">
                        FRN
                    </li>
                    <li data-needle-type="FRX" class="nadelsymbol needle-selector"
                        data-original-title="nadformF nadartR nadmerkX"
                        data-sketchfabid="8b529d9d84aa4e3aae40db57d065cf5c">
                        FRX
                    </li>
                    <li data-needle-type="GR" class="nadelsymbol needle-selector"
                        data-original-title="nadformG nadartR"
                        data-sketchfabid="9ce4dc166bae4b71ad436c079ff2503a">
                        GR
                    </li>
                    <li data-needle-type="GS" class="nadelsymbol needle-selector"
                        data-original-title="nadformG nadartS"
                        data-sketchfabid="2170b99bcdc24d9c8b3437a496a64d4a">
                        GS
                    </li>
                    <li data-needle-type="HR" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR"
                        data-sketchfabid="c82630a1392844629be866a079985e98">
                        HR
                    </li>
                    <li data-needle-type="HRK" class="needle-selector hidden"
                        data-original-title="nadformH nadartR nadmerkKA"
                        data-sketchfabid="c49d3328d4f740b69ec9ec7225ed638a">
                        HRK
                    </li>
                    <li data-needle-type="HRN" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR nadmerkN"
                        data-sketchfabid="3678e66a2bae4682a8c1d24382866f96">
                        HRN
                    </li>
                    <li data-needle-type="HRT" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR nadmerkT"
                        data-sketchfabid="9b06513a57d6457c9150e15d629267df">
                        HRT
                    </li>
                    <li data-needle-type="HRX" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR nadmerkX"
                        data-sketchfabid="0d6f129f4a754b5bb850460852165c86">
                        HRX
                    </li>
                    <li data-needle-type="HS" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartS"
                        data-sketchfabid="9f35e62b64ce422d844487c0406bfba2">
                        HS
                    </li>
                    <li data-needle-type="HSL" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartS nadmerkL"
                        data-sketchfabid="b9d67653242240c5af7efbc4574009d9">
                        HSL
                    </li>
                    <li data-needle-type="HSM" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartS nadmerkM"
                        data-sketchfabid="51b1534603704bf38cb0aae50adbc0ad">
                        HSM
                    </li>
                    <li data-needle-type="KS" class="nadelsymbol needle-selector"
                        data-original-title="nadformK nadartS"
                        data-sketchfabid="70599bd96cd944b592a7016045a80fb3">
                        KS
                    </li>
                    <li data-needle-type="LR" class="nadelsymbol needle-selector"
                        data-original-title="nadformL nadartR"
                        data-sketchfabid="9df98fed6cdc421ca3b408d071a2dfef">
                        LR
                    </li>
                    <li data-needle-type="DQL" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartQ nadmerkL"
                        data-sketchfabid="cc860f597f3742ae9da3e33393a01731">
                        DQL
                    </li>
                    <li data-needle-type="VSP" class="nadelsymbol needle-selector"
                        data-original-title="nadformV nadartS nadmerkSP"
                        data-sketchfabid="f6bf998a8a6d4f909e16c0142d951878">
                        VSP
                    </li>
                </ul>

            </div>
        </div>
        <div id="needle-a-legend" class="needle-legend needle-legend--a"></div>
    </div>

    <div class="viewer viewer-b">
        <iframe src="" id="viewer-b-frame" allow="autoplay; fullscreen; vr" allowvr allowfullscreen
                sandbox="allow-scripts allow-same-origin allow-popups allow-forms"
                mozallowfullscreen="true" webkitallowfullscreen="true"
                width="640" height="480" data-active-sketchfabid=""></iframe>
        <div class="model-selection model-selection-b">
            <div class="dropdown">
                <button class="btn btn-primary" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <span class="icon icon-down-open"></span>
                </button>
                <ul class="dropdown-menu nav-needles">
                    <li data-needle-type="DRN" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartR nadmerkN"
                        data-sketchfabid="fba84af4b7ec48189933ca73326bd122">
                        DRN
                    </li>
                    <li data-needle-type="DRT" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartR nadmerkT"
                        data-sketchfabid="5688320311e643cd835df1f34f385475">
                        DRT
                    </li>
                    <li data-needle-type="DRM" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartR nadmerkM"
                        data-sketchfabid="75dea4842bd54dc790d972c096a48f32">
                        DRM
                    </li>
                    <li data-needle-type="DSS" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS nadmerkS"
                        data-sketchfabid="ab930ba2fd8d4b289beb268fa403019b">
                        DSS
                    </li>
                    <li data-needle-type="DSL" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS nadmerkL"
                        data-sketchfabid="ec3e5f7ca3f144169d48d45fc06f5581">
                        DSL
                    </li>
                    <li data-needle-type="DSLA" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadmerkA nadartS nadmerkL"
                        data-sketchfabid="751f81a67c1f4c1b86bf5bd12337aa2f">
                        DSLA
                    </li>
                    <li data-needle-type="DS" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS"
                        data-sketchfabid="88499d1e2478417d85aed915afdec95d">
                        DS
                    </li>
                    <li data-needle-type="DSX" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartS nadmerkX"
                        data-sketchfabid="5b33a20669494b35934b78eb833c4c41">
                        DSX
                    </li>
                    <li data-needle-type="FRN" class="nadelsymbol needle-selector"
                        data-original-title="nadformF nadartR nadmerkN"
                        data-sketchfabid="d4b8cfce6f844d48a3f75179edd7bd41">
                        FRN
                    </li>
                    <li data-needle-type="FRX" class="nadelsymbol needle-selector"
                        data-original-title="nadformF nadartR nadmerkX"
                        data-sketchfabid="8b529d9d84aa4e3aae40db57d065cf5c">
                        FRX
                    </li>
                    <li data-needle-type="GR" class="nadelsymbol needle-selector"
                        data-original-title="nadformG nadartR"
                        data-sketchfabid="9ce4dc166bae4b71ad436c079ff2503a">
                        GR
                    </li>
                    <li data-needle-type="GS" class="nadelsymbol needle-selector"
                        data-original-title="nadformG nadartS"
                        data-sketchfabid="2170b99bcdc24d9c8b3437a496a64d4a">
                        GS
                    </li>
                    <li data-needle-type="HR" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR"
                        data-sketchfabid="c82630a1392844629be866a079985e98">
                        HR
                    </li>
                    <li data-needle-type="HRK" class="needle-selector hidden"
                        data-original-title="nadformH nadartR, nadmerkKA"
                        data-sketchfabid="c49d3328d4f740b69ec9ec7225ed638a">
                        HRK
                    </li>
                    <li data-needle-type="HRN" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR nadmerkN"
                        data-sketchfabid="3678e66a2bae4682a8c1d24382866f96">
                        HRN
                    </li>
                    <li data-needle-type="HRT" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR nadmerkT"
                        data-sketchfabid="9b06513a57d6457c9150e15d629267df">
                        HRT
                    </li>
                    <li data-needle-type="HRX" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartR nadmerkX]]"
                        data-sketchfabid="0d6f129f4a754b5bb850460852165c86">
                        HRX
                    </li>
                    <li data-needle-type="HS" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartS"
                        data-sketchfabid="9f35e62b64ce422d844487c0406bfba2">
                        HS
                    </li>
                    <li data-needle-type="HSL" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartS nadmerkL"
                        data-sketchfabid="b9d67653242240c5af7efbc4574009d9">
                        HSL
                    </li>
                    <li data-needle-type="HSM" class="nadelsymbol needle-selector"
                        data-original-title="nadformH nadartS nadmerkM"
                        data-sketchfabid="51b1534603704bf38cb0aae50adbc0ad">
                        HSM
                    </li>
                    <li data-needle-type="KS" class="nadelsymbol needle-selector"
                        data-original-title="nadformK nadartS"
                        data-sketchfabid="70599bd96cd944b592a7016045a80fb3">
                        KS
                    </li>
                    <li data-needle-type="LR" class="nadelsymbol needle-selector"
                        data-original-title="nadformL nadartR"
                        data-sketchfabid="9df98fed6cdc421ca3b408d071a2dfef">
                        LR
                    </li>
                    <li data-needle-type="DQL" class="nadelsymbol needle-selector"
                        data-original-title="nadformD nadartQ nadmerkL"
                        data-sketchfabid="cc860f597f3742ae9da3e33393a01731">
                        DQL
                    </li>
                    <li data-needle-type="VSP" class="nadelsymbol needle-selector"
                        data-original-title="nadformV nadartS nadmerkSP"
                        data-sketchfabid="f6bf998a8a6d4f909e16c0142d951878">
                        VSP
                    </li>
                </ul>
            </div>
        </div>

        <div id="needle-b-legend" class="needle-legend needle-legend--b"></div>

    </div>

</div>

<script src="/typo3conf/ext/seragwiessner_sitepackage/Resources/Public/JavaScript/jquery.min.js"></script>
<script src="/typo3conf/ext/seragwiessner_sitepackage/Resources/Public/JavaScript/bootstrap.min.js"></script>

<!-- Initialize the viewer -->
<script src="./js/vendors/gl-matrix.js"></script>
<script src="/typo3conf/ext/amdsshowroom/Resources/Public/JavaScript/sketchfab-viewer-1.12.1.js"></script>
<script type="text/javascript">

    var CAMERA_POLLING_INTERVAL = 100;
    var CAMERA_DELTA = 0.00001;

    const translations = {
        cs: {
            nadHint: "Bitte Nadel wählen",
            nadSelect: "Select needle",

            nadformD: "3/8kruhová;",
            nadformF: "5/8kruhová;",
            nadformG: "rovná;",
            nadformH: "1/2kruhová;",
            nadformK: "polozakřivená;",
            nadformL: "lžícovitá;",
            nadformV: "1/4kruhová;",

            nadartR: "s kulatým tělem;",
            nadartS: "obráceně řezací;",
            nadartQ: "quadratischer Nadelkörper;",

            nadmerkA: "asymptotická",
            nadmerkF: "štíhlá jehla",
            nadmerkK: "kopinatá špička",
            nadmerkKA: "Spitze mit kurzem Anschliff",
            nadmerkL: "špice ve tvaru kopí",
            nadmerkM: "mikrošpička",
            nadmerkN: "tupá jehla s kulatým tělem",
            nadmerkS: "štíhlá",
            nadmerkSP: "špachtlovitá jehla",
            nadmerkT: "extra silná jehla",
            nadmerkX: "extra strong"
        },
        de: {
            nadHint: "Bitte Nadel wählen",
            nadSelect: "Nadelauswahl",

            nadformD: "3/8 kreisförmig;",
            nadformF: "5/8 kreisförmig;",
            nadformG: "gerade Nadel;",
            nadformH: "1/2 kreisförmig;",
            nadformK: "Kufennadel;",
            nadformL: "Löffelnadel;",
            nadformV: "1/4 kreisförmig;",

            nadartR: "Rundkörpernadel;",
            nadartS: "schneidender Nadelkörper;",
            nadartQ: "quadratischer Nadelkörper;",

            nadmerkA: "asymptotisch",
            nadmerkF: "feine Nadel",
            nadmerkK: "kurze innenliegende Schneide",
            nadmerkKA: "Spitze mit kurzem Anschliff",
            nadmerkL: "Lanzettspitze",
            nadmerkM: "Mikrokurzschliff",
            nadmerkN: "stumpfe Rundkörpernadel",
            nadmerkS: "schlanker Anschliff",
            nadmerkSP: "Spatelnadel",
            nadmerkT: "Trokarnadel",
            nadmerkX: "extra stark"
        },
        en: {
            nadHint: "Bitte Nadel wählen",
            nadSelect: "Select needle",

            nadformD: "3/8 circle;",
            nadformF: "5/8 circle;",
            nadformG: "straight needle;",
            nadformH: "1/2 circle;",
            nadformK: "semi-curved;",
            nadformL: "spoon needle;",
            nadformV: "1/4 circle;",

            nadartR: "round-bodied needle;",
            nadartS: "reverse-cutting needle;",
            nadartQ: "quadratischer Nadelkörper;",

            nadmerkA: "asymptotic",
            nadmerkF: "fine needle",
            nadmerkK: "taper cutting",
            nadmerkKA: "Spitze mit kurzem Anschliff",
            nadmerkL: "lancet point",
            nadmerkM: "micro point",
            nadmerkN: "blunt, round-bodied needle",
            nadmerkS: "slim point",
            nadmerkSP: "spatula needle",
            nadmerkT: "trocar point",
            nadmerkX: "extra strong"
        }
    };

    const appLang = document.documentElement.lang;
    let textLang = appLang.substring(0, 2);

    var dropdowns = document.querySelectorAll("span.icon-down-open");

    for (var i = 0, len = dropdowns.length; i < len; i++) {
        dropdowns[i].innerHTML = translations[textLang]["nadSelect"];
    }

    document.querySelector(".showroomhint > span").innerHTML = translations[textLang]["nadHint"];


    var uidA = '';
    var uidB = '';

    var skViewer = {

        initialize: function () {
            var version = '1.5.2';

            var iframeA = document.getElementById('viewer-a-frame');
            var iframeB = document.getElementById('viewer-b-frame');

            this.currentViewer = false;

            this.viewers = {
                'a': {
                    _id: 'a',
                    api: null,
                    client: new Sketchfab(version, iframeA),
                    ready: false,
                    camera: null,
                    previousCamera: {
                        position: [0, 0, 0],
                        target: [0, 0, 0]
                    }
                },
                'b': {
                    _id: 'b',
                    api: null,
                    client: new Sketchfab(version, iframeB),
                    ready: false,
                    camera: null,
                    previousCamera: {
                        position: [0, 0, 0],
                        target: [0, 0, 0]
                    }
                }
            };

            this.initViewers();
        },

        initViewers: function () {


            this.stopCameraPolling();
            this.viewers.a.ready = false;
            this.viewers.b.ready = false;
            var urlidA = uidA;
            var urlidB = uidB;


            if (urlidA !== '') {
                this.viewers.a.client.init(urlidA, {
                    camera: 0,
                    success: function onSuccess(apiA) {
                        this.viewers.a.api = apiA;
                        apiA.start();
                        apiA.addEventListener('viewerready', function () {
                            this.viewers.a.ready = true;
                            this.onViewersReady();
                        }.bind(this));
                    }.bind(this),
                    error: function onError() {
                        console.log('Viewer A error');
                    }
                });
            }
            if (urlidB !='') {
                this.viewers.b.client.init(urlidB, {
                    camera: 0,
                    success: function onSuccess(apiB) {
                        this.viewers.b.api = apiB;
                        apiB.start();
                        apiB.addEventListener('viewerready', function () {
                            this.viewers.b.ready = true;
                            this.onViewersReady();
                        }.bind(this));
                    }.bind(this),
                    error: function onError() {
                        console.log('Viewer B error');
                    }
                });
            }
        },

        onViewersReady: function () {

            var self = this;

            if (this.viewers.a.ready && this.viewers.b.ready) {

                this.startCameraPolling();

                this.viewers.a.api.setCameraLookAt([0, -10, 0], [0, 0, 0], 1.0);
                this.viewers.b.api.setCameraLookAt([0, -10, 0], [0, 0, 0], 1.0);
            }
        },

        startCameraPolling: function () {
            this._pollingTimer = setInterval(function () {
                this.viewers.a.api.getCameraLookAt(function (err, camera) {
                    this.viewers.a.camera = camera;
                    this._onCameraPolled(this.viewers.a);
                }.bind(this));
                this.viewers.b.api.getCameraLookAt(function (err, camera) {
                    this.viewers.b.camera = camera;
                    this._onCameraPolled(this.viewers.b);
                }.bind(this));
            }.bind(this), CAMERA_POLLING_INTERVAL);
        },

        stopCameraPolling: function () {
            if (this._pollingTimer) {
                window.clearInterval(this._pollingTimer);
            }
        },

        _onCameraPolled: function (viewer) {
            var camera = viewer.camera;
            var previousCamera = viewer.previousCamera;

            var positionDistance = vec3.distance(
                vec3.fromValues(camera.position[0], camera.position[1], camera.position[2]),
                vec3.fromValues(previousCamera.position[0], previousCamera.position[1], previousCamera.position[2])
            );
            var targetDistance = vec3.distance(
                vec3.fromValues(camera.target[0], camera.target[1], camera.target[2]),
                vec3.fromValues(previousCamera.target[0], previousCamera.target[1], previousCamera.target[2])
            );

            viewer.previousCamera = camera;
            var totalDistance = positionDistance + targetDistance;
            if (totalDistance < CAMERA_DELTA) {
                if (this.currentViewer !== false) {
                    this.currentViewer = false;
                }
            } else {
                if (this.currentViewer === false) {
                    this.currentViewer = viewer._id;
                }

                if (this.currentViewer === 'a') {
                    this.viewers.b.api.setCameraLookAt(camera.position, camera.target, 0);
                }
                if (this.currentViewer === 'b') {
                    this.viewers.a.api.setCameraLookAt(camera.position, camera.target, 0);
                }
            }
        },

        onViewerASubmit: function (e) {
            e.preventDefault();
            this.initViewers();
        },

        onViewerBSubmit: function (e) {
            e.preventDefault();
            this.initViewers();
        }
    };

    skViewer.initialize();


    $(() => {
        $('.model-selection').on('click',(evt)=>{
            evt.preventDefault();
            $(evt.currentTarget).show();
        });
        $('.model-selection-a .needle-selector').on('click',(evt)=>{
            evt.preventDefault();
            needle =$(evt.currentTarget)
            uidA = needle.data('sketchfabid');

            var descriptionCode = needle.data('original-title').split(" ");

            descriptionCode.forEach(function(element, index) {
                this[index] = translations[textLang][element];
            }, descriptionCode);

            $('#needle-a-legend').html('<h2>' + needle.data('needle-type') + '</h2>' + '<p class="small">' + descriptionCode.join("").replace(/;/g, '<br>') + '</p> ').delay(2000).fadeIn('slow')

            skViewer.initViewers();
        });

        $('.model-selection-b .needle-selector').on('click',(evt)=>{
            evt.preventDefault();
            needle =$(evt.currentTarget)
            uidB = needle.data('sketchfabid');

            var descriptionCode = needle.data('original-title').split(" ");

            descriptionCode.forEach(function(element, index) {
                this[index] = translations[textLang][element];
            }, descriptionCode);

            $('#needle-b-legend').html('<h2>' + needle.data('needle-type') + '</h2>' + '<p class="small">' + descriptionCode.join("").replace(/;/g, '<br>') + '</p> ').delay(2000).fadeIn('slow')

            skViewer.initViewers();
        });
    });

</script>

</body>
</html>
