!function ($) {
    $(function () {
            $('#openCompareViewBtn').on('click', function (evt) {
                evt.preventDefault();
            })

            var windowHeight = $(window).height(),
                heroOffset = $('#hero').offset().top,
                heroMaxHeight = windowHeight - heroOffset,
                skfbSoloMaxHeight = windowHeight - heroOffset + 30,
                legende = $('#nadellegende');

            function changeLegend(nadeltyp, nadelbeschreibung) {
                legende.html('<h2>' + nadeltyp + '</h2>' + '<p class="small">' + nadelbeschreibung.replace(/,/g, '<br>') + '</p> ').delay(2000).fadeIn('slow')
            }

            function hideLegende() {
                legende.fadeOut('slow')
            }


            /*  Sketchfab solo  */

            function sketchfab(urlid, nadeltyp, nadelbeschreibung) {

                var iframe = $('#skfbModel')[0];
                var version = '1.12.1';
                var urlid;
                var client = new Sketchfab(version, iframe);

                var success = function onSuccess(api) {
                    api.load(
                        function () {
                            console.log('API Load')
                        }
                    )

                    api.start(
                        function () {
                            changeLegend(nadeltyp, nadelbeschreibung)
                            console.log('API start');
                        }
                    );
                }

                var error = function onError() {
                    console.log('Viewer error');
                };

                client.init(urlid, {
                    success: success,
                    error: error,
                    camera: 1,
                    autospin: -0.2,
                    preload: 0,
                    transparent: 0,
                    ui_infos: 0,
                    ui_related: 0,
                    ui_controls: 0,
                    ui_stop: 0,
                    scrollwheel: 1
                });
            }

            //$('#hero').height(heroMaxHeight);

            //$('#skfbSolo').height(skfbSoloMaxHeight);


            /* Sketchfab selektor */

            $('#nadelselektor').on('click', '.nadelsymbol', function (e) {

                var sketchfabid = $(this).attr('data-sketchfabid'),
                    nadeltyp = $(this).html().trim(),
                    nadelbeschreibung = $(this).attr('title');

                sketchfab(sketchfabid, nadeltyp, nadelbeschreibung);
                hideLegende();
                console.log('Nadeltyp: ' + nadeltyp + ', Beschreibung: ' + nadelbeschreibung + ', skfbID: ' + sketchfabid)
            });
        }
    )
}(window.jQuery);

