<?php

namespace amadeus\AmdsProdukte\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

class ProduktRepository extends Repository
{
    public function findAttributesBySeries(string $search, string $ordering) {
        $query = $this->createQuery();
        if ($search == 'SERAMON') {
            $query->matching(
                $query->logicalAnd(
                    [
                        $query->equals('ammate', $search),
                        $query->equals('amspez', '')
                    ]
                )
            );
        } elseif ($search == 'SERAMON-CHORDAE-LOOP') {
            $query->matching(
                $query->logicalAnd(
                    [
                        $query->equals('ammate', 'SERAMON'),
                        $query->logicalNot(
                            $query->equals('amspez', '')
                        )
                    ]
                )
            );
        } else {
            $query->matching($query->equals('ammate', $search));
        }

        $query->setOrderings(
            [
                $ordering => QueryInterface::ORDER_ASCENDING
            ]
        );

        return $query->execute();
    }

    public function findFederoehrnadelnAll() {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                [
                    $query->equals('ammate', 'Federöhrnadeln'),
                    $query->equals('adarth', 'NADELN')
                ]
            )
        );

        $query->setOrderings(
            [
                'ambez2' => QueryInterface::ORDER_ASCENDING,
                'amnlg1' => QueryInterface::ORDER_ASCENDING,
                'amspez' => QueryInterface::ORDER_ASCENDING,
                'amnaz1' => QueryInterface::ORDER_ASCENDING,
                'amfsep' => QueryInterface::ORDER_ASCENDING,
                'adstrl' => QueryInterface::ORDER_ASCENDING
            ]
        );

        return $query->execute();
    }

    public function findLoesungenBySeries(string $search) {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                [
                    $query->equals('g1', '02'),
                    //$query->like('ambez1', $search . ';%')
                    $query->equals('ammate', $search)
                ]
            )
        );

        $query->setOrderings(
            [
                'amartn' => QueryInterface::ORDER_ASCENDING,
                'ambez1' => QueryInterface::ORDER_ASCENDING,
                'amnlg1' => QueryInterface::ORDER_ASCENDING,
                'amspez' => QueryInterface::ORDER_ASCENDING,
                'amnaz1' => QueryInterface::ORDER_ASCENDING,
                'amfsep' => QueryInterface::ORDER_ASCENDING
            ]
        );

        return $query->execute();
    }

    public function findNahtmaterialBenadeltBySeries(string $search) {
        $query = $this->createQuery();
        if ($search == 'SERAMON') {
            $query->matching(
                $query->logicalAnd(
                    [
                        $query->equals('ammate', 'SERAMON'),
                        $query->logicalOr(
                            $query->equals('amspez', ''),
                            $query->like('amspez', 'OPLEDGETS')
                        ),
                        $query->equals('adarth', 'NM'),
                        $query->greaterThan('amnaz1', 0)
                    ]
                )
            );
        } elseif ($search == 'SERAMON-CHORDAE-LOOP') {
            $query->matching(
                $query->logicalAnd(
                    [
                        $query->equals('ammate', 'SERAMON'),
                        $query->equals('amspez','CHORDAE-LOOP'),
                        $query->equals('adarth', 'NM'),
                        $query->greaterThan('amnaz1', 0)
                    ]
                )
            );
        } else {
            $query->matching(
                $query->logicalAnd(
                    [
                        $query->equals('ammate', $search),
                        $query->equals('adarth', 'NM'),
                        $query->greaterThan('amnaz1', 0)
                    ]
                )
            );
        }

        $query->setOrderings(
            [
                'amnty1' => QueryInterface::ORDER_ASCENDING,
                'amnlg1' => QueryInterface::ORDER_ASCENDING,
                'amspez' => QueryInterface::ORDER_ASCENDING,
                'amnar1' => QueryInterface::ORDER_ASCENDING,
                'amnaz1' => QueryInterface::ORDER_ASCENDING,
                'amfsep' => QueryInterface::ORDER_ASCENDING
            ]
        );

        return $query->execute();
    }

    public function countNahtmaterialBySeries(string $search, int $mode): int {
        $params = explode("|", $search);
        $query = $this->createQuery();
        switch ($mode) {
            case 0:
                $query->matching(
                    $query->logicalAnd(
                        [
                            $query->equals('ammate', $params[0]),
                            $query->equals('amnty1',$params[1]),
                            $query->equals('amnlg1',$params[2]),
                            $query->equals('amnaz1',1),
                            $query->equals('amspez', $params[4]),
                            $query->equals('amnar1', $params[5])
                        ]
                    )
                );
                break;
            case 1:
                $query->matching(
                    $query->logicalAnd(
                        [
                            $query->equals('ammate', $params[0]),
                            $query->equals('amnty1',$params[1]),
                            $query->equals('amnlg1',$params[2]),
                            $query->equals('amnaz1',2),
                            $query->equals('amspez', $params[4]),
                            $query->equals('amnar1', $params[5])
                        ]
                    )
                );
                break;
            case 2:
                $query->matching(
                    $query->logicalAnd(
                        [
                            $query->equals('ammate', $params[0]),
                            $query->equals('amnty1',$params[1]),
                            $query->equals('amnlg1',$params[2]),
                            $query->equals('amnaz1',$params[3]),
                            $query->equals('amspez', $params[4]),
                            $query->equals('amnar1', $params[5])
                        ]
                    )
                );
                break;
        }

        return $query->count();
    }

    public function findNahtmaterialBySeries(string $search) {
        $query = $this->createQuery();
        $query->matching(
            $query->logicalAnd(
                [
                    $query->equals('ammate', $search),
                    $query->equals('adarth','NM'),
                    $query->equals('amnaz1','')
                ]
            )
        );

        $query->setOrderings(
            [
                'amspez' => QueryInterface::ORDER_ASCENDING,
                'amfsep' => QueryInterface::ORDER_ASCENDING,
                'amlang' => QueryInterface::ORDER_ASCENDING,
                'amfanz' => QueryInterface::ORDER_ASCENDING,
                'amfarb' => QueryInterface::ORDER_ASCENDING,
                'advpe' => QueryInterface::ORDER_ASCENDING
            ]
        );

        return $query->execute();
    }

    public function findNetzeBySeries(string $search, int $mode = 0, string $spezial = '') {
        $query = $this->createQuery();
        if ($mode == 1) {
            $ids = explode(";", $search);
            $query->matching(
                $query->logicalAnd(
                    [
                        $query->in('amartn', $ids),
                        $query->equals('adarth', 'NETZE')
                    ]
                )
            );
        } else {
            if ($spezial == 'leer') {
                $query->matching(
                    $query->logicalAnd(
                        [
                            $query->equals('ammate', $search),
                            $query->equals('adarth', 'NETZE'),
                            $query->equals('amspez', '')
                        ]
                    )
                );
            } elseif ($spezial !== '') {
                $query->matching(
                    $query->logicalAnd(
                        [
                            $query->equals('ammate', $search),
                            $query->equals('adarth', 'NETZE'),
                            $query->equals('amspez', $spezial)
                        ]
                    )
                );
            } else {
                $query->matching(
                    $query->logicalAnd(
                        [
                            $query->equals('ammate', $search),
                            $query->equals('adarth', 'NETZE')
                        ]
                    )
                );
            }
        }

        $query->setOrderings(
            [
                'resorbierbar' => QueryInterface::ORDER_ASCENDING,
                'ammate' => QueryInterface::ORDER_ASCENDING,
                'material2' => QueryInterface::ORDER_ASCENDING,
                'amartn' => QueryInterface::ORDER_ASCENDING,
                'amnlg1' => QueryInterface::ORDER_ASCENDING,
                'amspez' => QueryInterface::ORDER_ASCENDING
            ]
        );

        return $query->execute();
    }
}