<?php


namespace amadeus\AmdsProdukte\Controller;

use amadeus\AmdsProdukte\Domain\Repository\ProduktRepository;
use amadeus\AmdsProdukte\Domain\Utility\Setup;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Psr\Http\Message\ResponseInterface;


class ProduktController extends ActionController
{
    private $produktRepo;
    protected $args = array();
    private $getVars;

    public function injectProduktRepository(ProduktRepository $produktRepository):void {
        $this->produktRepo = $produktRepository;
    }

    public function federoehrAction() {
        $context = GeneralUtility::makeInstance(Context::class);
        $langId = $context->getPropertyFromAspect('language', 'id');
        $results = $this->produktRepo->findFederoehrnadelnAll();
        $variations = array();
        $setup = array();

        for ($i = 0; $i < count($results); $i++) {
            $variations[$i] = '' . $results[$i]->getAmnty1() . ',' . $results[$i]->getNadform1() . ',' . $results[$i]->getNadart1() . ',' . $results[$i]->getNadmerk1();
            $results[$i]->setStrings();
        }

        $variation = array_unique($variations);
        asort($variation);

        foreach ($variation as $var) {
            $temp = explode(',',$var);
            array_push($setup, new Setup($temp[0], $temp[1], $temp[2], $temp[3]));
        }

        $this->view->assign('results', $results);
        $this->view->assign('lswitch', $langId);
        $this->view->assign('setups', $setup);

        return $this->view->render();
    }

    public function loesungenAction() {
        $context = GeneralUtility::makeInstance(Context::class);
        $langId = $context->getPropertyFromAspect('language', 'id');
        $args[0] = $this->settings['searchProdCat'];
        $args[1] = $this->settings['searchTableHeader'];
        $args[2] = $this->settings['searchDownloadInstructions'];
        $results = $this->produktRepo->findLoesungenBySeries($args[0]);
        $this->view->assign('query', $args);
        $this->view->assign('results', $results);
        $this->view->assign('lswitch', $langId);

        return $this->view->render();
    }

    public function nahtmaterialAction() {
        $context = GeneralUtility::makeInstance(Context::class);
        $langId = $context->getPropertyFromAspect('language', 'id');
        $args[0] = $this->settings['searchProdCat'];
        $args[1] = $this->settings['searchTableHeader'];
        $resultsN = $this->produktRepo->findNahtmaterialBenadeltBySeries($args[0]);
        $results = $this->produktRepo->findNahtmaterialBySeries($args[0]);
        $resultsA = $this->produktRepo->findAttributesBySeries($args[0], 'amlang');
        $variations = array();
        $setup = array();

        for ($i = 0; $i < count($resultsN); $i++) {
            $variations[$i] = '' . $resultsN[$i]->getAmnty1() . ',' . $resultsN[$i]->getNadform1() . ',' . $resultsN[$i]->getNadart1() . ',' . $resultsN[$i]->getNadmerk1();
            $params = '' . $args[0] . '|' . $resultsN[$i]->getAmnty1() . '|' . $resultsN[$i]->getAmnlg1() . '|' . $resultsN[$i]->getAmnaz1() . '|' . $resultsN[$i]->getAmspez(). '|' . $resultsN[$i]->getAmnar1();
            $resultsN[$i]->setCounts($this->produktRepo->countNahtmaterialBySeries($params, 2));
            $resultsN[$i]->setStrings();
            $resultsN[$i]->setAmfsep(str_replace(".", ",", (int)$resultsN[$i]->getAmfsep() * 0.1));
            $resultsN[$i]->setAmlang((int)$resultsN[$i]->getAmlang() * 0.1);
            $resultsN[$i]->setColFaden((int)$resultsN[$i]->getAmfanz() . ' &times; ' . str_replace('.', ',', $resultsN[$i]->getAmlang()) . ' cm');
        }

        for ($i = 0; $i < count($results); $i++) {
            $results[$i]->setColSpan(count($results));
            $results[$i]->setAmfsep(str_replace(".", ",", (int)$results[$i]->getAmfsep() * 0.1));
            $results[$i]->setAmlang((int)$results[$i]->getAmlang() * 0.1);
            $results[$i]->setColFaden((int)$results[$i]->getAmfanz() . ' &times; ' . str_replace('.', ',', $results[$i]->getAmlang()) . ' cm');
        }

        for ($i = 0; $i < count($resultsA); $i++) {
            $amlangs[$i] = $resultsA[$i]->getAmlang();
            $amfseps[$i] = str_replace(".", ",", $resultsA[$i]->getAmfsep());
            $amfusps[$i] = $resultsA[$i]->getAmfusp();
        }

        $filterLang = array_unique($amlangs);
        sort($filterLang, SORT_NUMERIC);
        $filterSep = array_unique($amfseps);
        sort($filterSep);
        $filterUsp = array_unique($amfusps);
        sort($filterUsp);
        $variation = array_unique($variations);

        foreach ($variation as $var) {
            $temp = explode(',',$var);
            array_push($setup, new Setup($temp[0], $temp[1], $temp[2], $temp[3]));
        }

        $filterCat1 = array();
        $filterCat2 = array();

        foreach ($filterUsp as $filter) {
            if (stristr($filter, '/') === false) {
                $filterCat2[] = $filter;
            } else {
                $filterCat1[] = $filter;
            }
        }

        $filterUspO = array_merge(array_reverse($filterCat1), $filterCat2);

        $this->view->assign('query', $args);
        $this->view->assign('results', $resultsN);
        $this->view->assign('resultsON', $results);
        $this->view->assign('filterLang', implode(",", $filterLang));
        $this->view->assign('filterSep', $filterSep);
        $this->view->assign('filterSepS', implode(",", $filterSep));
        $this->view->assign('filterUsp', $filterUspO);
        $this->view->assign('filterUspS', implode(",", $filterUsp));
        $this->view->assign('lswitch', $langId);
        $this->view->assign('setups', $setup);

        return $this->view->render();
    }

    public function netzeAction() {
        $context = GeneralUtility::makeInstance(Context::class);
        $langId = $context->getPropertyFromAspect('language', 'id');
        $args[0] = $this->settings['searchProdCat'];
        $args[1] = $this->settings['searchTableHeader'];
        $args[2] = $this->settings['searchMode'];
        $args[3] = $this->settings['searchSpecial'];
        $args[4] = $this->settings['searchExclude'];
        $results = $this->produktRepo->findNetzeBySeries($args[0],$args[2],$args[3], $args[4]);
        $variations = array();
        $setup = array();

        for ($i = 0; $i < count($results); $i++) {
            $results[$i]->setIconClass('implantat-' . str_replace(array(' ', '(', ')', '+', '/'), array('-', ''), strtolower($results[$i]->getAmbez3())));
            $results[$i]->setColName(0, $results[$i]->splitString($results[$i]->getAdltx0()));
            $results[$i]->setColName(1, $results[$i]->splitString($results[$i]->getAdltx1()));

            $variations[$i] = '' . $results[$i]->getMaterial2() . ',' . $results[$i]->getResorbierbar() . ',' . $results[$i]->getFadenstruktur();
        }

        // Alle einzigartigen Eigenschafts-Kombinationen, die in den Ergebnissen vorkommen. Für jede wird eine neue Tabelle aufgebaut
        $variation = array_unique($variations);

        foreach ($variation as $var) {
            $temp = explode(',',$var);
            array_push($setup, new Setup($temp[0],$temp[1],$temp[2]));
        }

        $this->view->assign('query', $args);
        $this->view->assign('results', $results);
        $this->view->assign('lswitch', $langId);
        $this->view->assign('setups', $setup);

        return $this->view->render();
    }
}