<?php

namespace amadeus\AmdsProdukte\Domain\Model;

use \TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Produkt extends AbstractEntity
{
    // keine Ahnung (ist entweder 01 oder 02)
    protected string $g1 = '';

    // Produktfamilie
    protected string $ammate = '';

    // Artikelnummer
    protected string $amartn = '';

    // Produktbezeichnung
    protected string $ambez1 = '';

    // Produktbezeichnung 2 (nicht verwendet)
    protected string $ambez2 = '';

    // KEIN IMPORTFELD - Teilstring von ambez1
    protected string $ambez3 = '';

    // Produktspezialisierung
    protected string $amspez = '';

    // Produktfarbe
    protected string $amfarb = '';

    // Produktattribute Nadeln
    protected string $amfanz = '';
    protected string $amfsep = '';
    protected string $amfusp = '';
    protected string $amlang = '';
    protected string $amnaz1 = '';
    protected string $nadform1 = '';
    protected string $nadart1 = '';
    protected string $nadmerk1 = '';

    // Kombination NADFORM1, NADART1, NADMERK1
    protected string $amnty1 = '';

    // Nadeldurchmesser
    protected string $amnlg1 = '';
    protected string $amnar1 = '';

    // Zur Zeit nicht verwendet
    protected string $amnaz2 = '';
    protected string $nadform2 = '';
    protected string $nadart2 = '';
    protected string $nadmerk2 = '';

    // Kombination NADFORM2, NADART2, NADMERK2 - Zur Zeit nicht verwendet
    protected string $amnty2 = '';
    protected string $amnlg2 = '';
    protected string $amnar2 = '';

    // Interna Serag-Wiessner (nicht verwendet)
    protected string $memo = '';
    protected string $pzn = '';
    protected string $fuell = '';
    protected string $le = '';
    protected string $status = '';

    // Material
    protected string $material2 = '';

    // Resorbierbar (Ja/Nein/Teilweise)
    protected string $resorbierbar = '';
    protected string $resorbtionsprofil = '';
    protected string $fadenstruktur = '';

    // ???
    protected string $adartg = '';

    // Produktkategorie
    protected string $adarth = '';

    // Sterilität
    protected string $adstrl = '';

    // Nur bei Nadeln: EP-Spanne
    protected string $adepe = '';

    // Nur bei Nadeln: USP-Spanne
    protected string $aduspe = '';#

    // ???
    protected int $advpe = 0;

    // ???
    protected string $admwar = '';

    // Produktpreis Brutto (nicht verwendet)
    protected float $adprbr = 0.00;

    // Produktpreis Netto (nicht verwendet)
    protected float $adprne = 0.00;

    // Produktpreis Verkauf (nicht verwendet)
    protected int $adprvk = 0;

    // Kodierung Packungsgröße
    protected string $adtftk = '';

    // Bezeichnung Packungsgröße DE
    protected string $adtftt = '';

    // Zur Zeit nicht verwendet
    protected string $adbehn = '';
    protected string $adbinh = '';
    protected string $adhafo = '';
    protected string $adhaft = '';

    // Pharmazentralnummer
    protected string $adphzn = '';

    // Produktbeschreibung DE
    protected string $adltx0 = '';

    // Produktbeschreibung EN
    protected string $adltx1 = '';

    // Produkt im Shop sichtbar machen ("Bestellen"-Button)
    protected int $adik4 = 0;

    // KEINE IMPORTDATEN; Werden aus obigen Attributen beim Anlegen zusammengeschraubt und im Frontend verwendet
    public $icon_class;
    public array $colName;
    public string $colFaden;
    public int $colSpan;
    public string $nadelString;
    public string $iconString;
    public string $iconSize;
    public int $counts;


    public function __construct(string $c_g1 = '', string $c_ammate = '', string $c_amartn = '', string $c_ambez1 = '', string $c_ambez2 = '', string $c_amspez = '', string $c_amfarb = '', string $c_amfanz = '', string $c_amfsep = '', string $c_amfusp = '', string $c_amlang = '', string $c_amnaz1 = '', string $c_nadform1 = '', string $c_nadart1 = '', string $c_nadmerk1 = '', string $c_amnty1 = '', string $c_amnlg1 = '', string $c_amnar1 = '', string $c_amnaz2 = '', string $c_nadform2 = '', string $c_nadart2 = '', string $c_nadmerk2 = '', string $c_amnty2 = '', string $c_amnlg2 = '', string $c_amnar2 = '', string $c_memo = '', string $c_pzn = '', string $c_fuell = '', string $c_le = '', string $c_status = '', string $c_material2 = '', string $c_resorbierbar = '', string $c_resoprofil = '', string $c_fadenstruktur = '', string $c_adartg = '', string $c_adarth = '', string $c_adstrl = '', string $c_adepe = '', string $c_aduspe = '', int $c_advpe = 0, int $c_admwar = 0, float $c_adprbr = 0.00, float $c_adprne = 0.00, int $c_adprvk = 0, string $c_adtftk = '', string $c_adtftt = '', string $c_adbehn = '', string $c_adbinh = '', string $c_adhafo = '', string $c_adhaft = '', string $c_adphzn = '', string $c_adltx0 = '', string $c_adltx1 = '', int $c_adik4 = 0)
    {
        $this->setG1($c_g1);
        $this->setAmmate($c_ammate);
        $this->setAmartn($c_amartn);
        $this->setAmbez1($c_ambez1);
        $this->setAmbez2($c_ambez2);
        $this->setAmspez($c_amspez);
        $this->setAmfarb($c_amfarb);
        $this->setAmfanz($c_amfanz);
        $this->setAmfsep($c_amfsep);
        $this->setAmfusp($c_amfusp);
        $this->setAmlang($c_amlang);
        $this->setAmnaz1($c_amnaz1);
        $this->setNadform1($c_nadform1);
        $this->setNadart1($c_nadart1);
        $this->setNadmerk1($c_nadmerk1);
        $this->setAmnty1($c_amnty1);
        $this->setAmnlg1($c_amnlg1);
        $this->setAmnar1($c_amnar1);
        $this->setAmnaz2($c_amnaz2);
        $this->setNadform2($c_nadform2);
        $this->setNadart2($c_nadart2);
        $this->setNadmerk2($c_nadmerk2);
        $this->setAmnty2($c_amnty2);
        $this->setAmnlg2($c_amnlg2);
        $this->setAmnar2($c_amnar2);
        $this->setMemo($c_memo);
        $this->setPzn($c_pzn);
        $this->setFuell($c_fuell);
        $this->setLe($c_le);
        $this->setStatus($c_status);
        $this->setMaterial2($c_material2);
        $this->setResorbierbar($c_resorbierbar);
        $this->setResorbtionsprofil($c_resoprofil);
        $this->setFadenstruktur($c_fadenstruktur);
        $this->setAdartg($c_adartg);
        $this->setAdarth($c_adarth);
        $this->setAdstrl($c_adstrl);
        $this->setAdepe($c_adepe);
        $this->setAduspe($c_aduspe);
        $this->setAdvpe($c_advpe);
        $this->setAdmwar($c_admwar);
        $this->setAdprbr($c_adprbr);
        $this->setAdprne($c_adprne);
        $this->setAdprvk($c_adprvk);
        $this->setAdtftk($c_adtftk);
        $this->setAdtftt($c_adtftt);
        $this->setAdbehn($c_adbehn);
        $this->setAdbinh($c_adbinh);
        $this->setAdhafo($c_adhafo);
        $this->setAdhaft($c_adhaft);
        $this->setAdphzn($c_adphzn);
        $this->setAdltx0($c_adltx0);
        $this->setAdltx1($c_adltx1);
        $this->setAdik4($c_adik4);

        $this->setColName(0, $this->splitString($c_adltx0));
        $this->setColName(1, $this->splitString($c_adltx1));
    }


    /**
     * @return string
     */
    public function getG1(): string
    {
        return $this->g1;
    }

    /**
     * @param string $g1
     */
    public function setG1(string $g1): void
    {
        $this->g1 = $g1;
    }

    /**
     * @return string
     */
    public function getAmmate(): string
    {
        return $this->ammate;
    }

    /**
     * @param string $ammate
     */
    public function setAmmate(string $ammate): void
    {
        $this->ammate = $ammate;
    }

    /**
     * @return string
     */
    public function getAmartn(): string
    {
        return $this->amartn;
    }

    /**
     * @param string $amartn
     */
    public function setAmartn(string $amartn): void
    {
        $this->amartn = $amartn;
    }

    /**
     * @return string
     */
    public function getAmbez1(): string
    {
        return $this->ambez1;
    }

    /**
     * @param string $ambez1
     */
    public function setAmbez1(string $ambez1): void
    {
        $this->ambez1 = $ambez1;
    }

    /**
     * @return string
     */
    public function getAmbez2(): string
    {
        return $this->ambez2;
    }

    /**
     * @param string $ambez2
     */
    public function setAmbez2(string $ambez2): void
    {
        $this->ambez2 = $ambez2;
    }

    /**
     * @return string
     */
    public function getAmbez3(): string
    {
        $splits = explode(';', $this->getAmbez1());
        return $splits[0];
    }

    /**
     * @param string $ambez3
     */
    public function setAmbez3(string $ambez3): void
    {
        $this->ambez3 = $ambez3;
    }

    /**
     * @return string
     */
    public function getAmspez(): string
    {
        return $this->amspez;
    }

    /**
     * @param string $amspez
     */
    public function setAmspez(string $amspez): void
    {
        $this->amspez = $amspez;
    }

    /**
     * @return string
     */
    public function getAmfarb(): string
    {
        return $this->amfarb;
    }

    /**
     * @param string $amfarb
     */
    public function setAmfarb(string $amfarb): void
    {
        $this->amfarb = $amfarb;
    }

    /**
     * @return string
     */
    public function getAmfanz(): string
    {
        return $this->amfanz;
    }

    /**
     * @param string $amfanz
     */
    public function setAmfanz(string $amfanz): void
    {
        $this->amfanz = $amfanz;
    }

    /**
     * @return string
     */
    public function getAmfsep(): string
    {
        return $this->amfsep;
    }

    /**
     * @param string $amfsep
     */
    public function setAmfsep(string $amfsep): void
    {
        $this->amfsep = $amfsep;
    }

    /**
     * @return string
     */
    public function getAmfusp(): string
    {
        return $this->amfusp;
    }

    /**
     * @param string $amfusp
     */
    public function setAmfusp(string $amfusp): void
    {
        $this->amfusp = $amfusp;
    }

    /**
     * @return string
     */
    public function getAmlang(): string
    {
        return $this->amlang;
    }

    /**
     * @param string $amlang
     */
    public function setAmlang(string $amlang): void
    {
        $this->amlang = $amlang;
    }

    /**
     * @return string
     */
    public function getAmnaz1(): string
    {
        return $this->amnaz1;
    }

    /**
     * @param string $amnaz1
     */
    public function setAmnaz1(string $amnaz1): void
    {
        $this->amnaz1 = $amnaz1;
    }

    /**
     * @return string
     */
    public function getNadform1(): string
    {
        return $this->nadform1;
    }

    /**
     * @param string $nadform1
     */
    public function setNadform1(string $nadform1): void
    {
        $this->nadform1 = $nadform1;
    }

    /**
     * @return string
     */
    public function getNadart1(): string
    {
        return $this->nadart1;
    }

    /**
     * @param string $nadart1
     */
    public function setNadart1(string $nadart1): void
    {
        $this->nadart1 = $nadart1;
    }

    /**
     * @return string
     */
    public function getNadmerk1(): string
    {
        return $this->nadmerk1;
    }

    /**
     * @param string $nadmerk1
     */
    public function setNadmerk1(string $nadmerk1): void
    {
        $this->nadmerk1 = $nadmerk1;
    }

    /**
     * @return string
     */
    public function getAmnty1(): string
    {
        return $this->amnty1;
    }

    /**
     * @param string $amnty1
     */
    public function setAmnty1(string $amnty1): void
    {
        $this->amnty1 = $amnty1;
    }

    /**
     * @return string
     */
    public function getAmnlg1(): string
    {
        return $this->amnlg1;
    }

    /**
     * @param string $amnlg1
     */
    public function setAmnlg1(string $amnlg1): void
    {
        $this->amnlg1 = $amnlg1;
    }

    /**
     * @return string
     */
    public function getAmnar1(): string
    {
        return $this->amnar1;
    }

    /**
     * @param string $amnar1
     */
    public function setAmnar1(string $amnar1): void
    {
        $this->amnar1 = $amnar1;
    }

    /**
     * @return string
     */
    public function getAmnaz2(): string
    {
        return $this->amnaz2;
    }

    /**
     * @param string $amnaz2
     */
    public function setAmnaz2(string $amnaz2): void
    {
        $this->amnaz2 = $amnaz2;
    }

    /**
     * @return string
     */
    public function getNadform2(): string
    {
        return $this->nadform2;
    }

    /**
     * @param string $nadform2
     */
    public function setNadform2(string $nadform2): void
    {
        $this->nadform2 = $nadform2;
    }

    /**
     * @return string
     */
    public function getNadart2(): string
    {
        return $this->nadart2;
    }

    /**
     * @param string $nadart2
     */
    public function setNadart2(string $nadart2): void
    {
        $this->nadart2 = $nadart2;
    }

    /**
     * @return string
     */
    public function getNadmerk2(): string
    {
        return $this->nadmerk2;
    }

    /**
     * @param string $nadmerk2
     */
    public function setNadmerk2(string $nadmerk2): void
    {
        $this->nadmerk2 = $nadmerk2;
    }

    /**
     * @return string
     */
    public function getAmnty2(): string
    {
        return $this->amnty2;
    }

    /**
     * @param string $amnty2
     */
    public function setAmnty2(string $amnty2): void
    {
        $this->amnty2 = $amnty2;
    }

    /**
     * @return string
     */
    public function getAmnlg2(): string
    {
        return $this->amnlg2;
    }

    /**
     * @param string $amnlg2
     */
    public function setAmnlg2(string $amnlg2): void
    {
        $this->amnlg2 = $amnlg2;
    }

    /**
     * @return string
     */
    public function getAmnar2(): string
    {
        return $this->amnar2;
    }

    /**
     * @param string $amnar2
     */
    public function setAmnar2(string $amnar2): void
    {
        $this->amnar2 = $amnar2;
    }

    /**
     * @return string
     */
    public function getMemo()
    {
        return $this->memo;
    }

    /**
     * @param string $memo
     */
    public function setMemo(string $memo): void
    {
        $this->memo = $memo;
    }

    /**
     * @return string
     */
    public function getPzn()
    {
        return $this->pzn;
    }

    /**
     * @param string $pzn
     */
    public function setPzn(string $pzn): void
    {
        $this->pzn = $pzn;
    }

    /**
     * @return string
     */
    public function getFuell()
    {
        return $this->fuell;
    }

    /**
     * @param string $fuell
     */
    public function setFuell(string $fuell): void
    {
        $this->fuell = $fuell;
    }

    /**
     * @return string
     */
    public function getLe()
    {
        return $this->le;
    }

    /**
     * @param string $le
     */
    public function setLe(string $le): void
    {
        $this->le = $le;
    }

    /**
     * @return string
     */
    public function getStatus(): string
    {
        return $this->status;
    }

    /**
     * @param string $status
     */
    public function setStatus(string $status): void
    {
        $this->status = $status;
    }

    /**
     * @return string
     */
    public function getMaterial2(): string
    {
        return $this->material2;
    }

    /**
     * @param string $material2
     */
    public function setMaterial2(string $material2): void
    {
        $this->material2 = $material2;
    }

    /**
     * @return string
     */
    public function getResorbierbar(): string
    {
        return $this->resorbierbar;
    }

    /**
     * @param string $resorbierbar
     */
    public function setResorbierbar(string $resorbierbar): void
    {
        $this->resorbierbar = $resorbierbar;
    }

    /**
     * @return string
     */
    public function getResorbtionsprofil(): string
    {
        return $this->resorbtionsprofil;
    }

    /**
     * @param string $resorbtionsprofil
     */
    public function setResorbtionsprofil(string $resorbtionsprofil): void
    {
        $this->resorbtionsprofil = $resorbtionsprofil;
    }

    /**
     * @return string
     */
    public function getFadenstruktur(): string
    {
        return $this->fadenstruktur;
    }

    /**
     * @param string $fadenstruktur
     */
    public function setFadenstruktur(string $fadenstruktur): void
    {
        $this->fadenstruktur = $fadenstruktur;
    }

    /**
     * @return string
     */
    public function getAdartg(): string
    {
        return $this->adartg;
    }

    /**
     * @param string $adartg
     */
    public function setAdartg(string $adartg): void
    {
        $this->adartg = $adartg;
    }

    /**
     * @return string
     */
    public function getAdarth(): string
    {
        return $this->adarth;
    }

    /**
     * @param string $adarth
     */
    public function setAdarth(string $adarth): void
    {
        $this->adarth = $adarth;
    }

    /**
     * @return string
     */
    public function getAdstrl(): string
    {
        return $this->adstrl;
    }

    /**
     * @param string $adstrl
     */
    public function setAdstrl(string $adstrl): void
    {
        $this->adstrl = $adstrl;
    }

    /**
     * @return string
     */
    public function getAdepe(): string
    {
        return $this->adepe;
    }

    /**
     * @param string $adepe
     */
    public function setAdepe(string $adepe): void
    {
        $this->adepe = $adepe;
    }

    /**
     * @return string
     */
    public function getAduspe(): string
    {
        return $this->aduspe;
    }

    /**
     * @param string $aduspe
     */
    public function setAduspe(string $aduspe): void
    {
        $this->aduspe = $aduspe;
    }

    /**
     * @return int
     */
    public function getAdvpe(): int
    {
        return $this->advpe;
    }

    /**
     * @param int $advpe
     */
    public function setAdvpe(int $advpe): void
    {
        $this->advpe = $advpe;
    }

    /**
     * @return string
     */
    public function getAdmwar(): string
    {
        return $this->admwar;
    }

    /**
     * @param string $admwar
     */
    public function setAdmwar(int $admwar): void
    {
        $this->admwar = $admwar;
    }

    /**
     * @return float
     */
    public function getAdprbr(): float
    {
        return $this->adprbr;
    }

    /**
     * @param float $adprbr
     */
    public function setAdprbr(float $adprbr): void
    {
        $this->adprbr = $adprbr;
    }

    /**
     * @return float
     */
    public function getAdprne(): float
    {
        return $this->adprne;
    }

    /**
     * @param float $adprne
     */
    public function setAdprne(float $adprne): void
    {
        $this->adprne = $adprne;
    }

    /**
     * @return int
     */
    public function getAdprvk(): int
    {
        return $this->adprvk;
    }

    /**
     * @param int $adprvk
     */
    public function setAdprvk(int $adprvk): void
    {
        $this->adprvk = $adprvk;
    }

    /**
     * @return string
     */
    public function getAdtftk(): string
    {
        return $this->adtftk;
    }

    /**
     * @param string $adtftk
     */
    public function setAdtftk(string $adtftk): void
    {
        $this->adtftk = $adtftk;
    }

    /**
     * @return string
     */
    public function getAdtftt(): string
    {
        return $this->adtftt;
    }

    /**
     * @param string $adtftt
     */
    public function setAdtftt(string $adtftt): void
    {
        $this->adtftt = $adtftt;
    }

    /**
     * @return string
     */
    public function getAdbehn(): string
    {
        return $this->adbehn;
    }

    /**
     * @param string $adbehn
     */
    public function setAdbehn(string $adbehn): void
    {
        $this->adbehn = $adbehn;
    }

    /**
     * @return string
     */
    public function getAdbinh(): string
    {
        return $this->adbinh;
    }

    /**
     * @param string $adbinh
     */
    public function setAdbinh(string $adbinh): void
    {
        $this->adbinh = $adbinh;
    }

    /**
     * @return string
     */
    public function getAdhafo(): string
    {
        return $this->adhafo;
    }

    /**
     * @param string $adhafo
     */
    public function setAdhafo(string $adhafo): void
    {
        $this->adhafo = $adhafo;
    }

    /**
     * @return string
     */
    public function getAdhaft(): string
    {
        return $this->adhaft;
    }

    /**
     * @param string $adhaft
     */
    public function setAdhaft(string $adhaft): void
    {
        $this->adhaft = $adhaft;
    }

    /**
     * @return string
     */
    public function getAdphzn(): string
    {
        return $this->adphzn;
    }

    /**
     * @param string $adphzn
     */
    public function setAdphzn(string $adphzn): void
    {
        $this->adphzn = $adphzn;
    }

    /**
     * @return string
     */
    public function getAdltx0(): string
    {
        return $this->adltx0;
    }

    /**
     * @param string $adltx0
     */
    public function setAdltx0(string $adltx0): void
    {
        $this->adltx0 = $adltx0;
    }

    /**
     * @return string
     */
    public function getAdltx1(): string
    {
        return $this->adltx1;
    }

    /**
     * @param string $adltx1
     */
    public function setAdltx1(string $adltx1): void
    {
        $this->adltx1 = $adltx1;
    }

    /**
     * @return int
     */
    public function getAdik4(): int
    {
        return $this->adik4;
    }

    /**
     * @param int $adik4
     */
    public function setAdik4(int $adik4): void
    {
        $this->adik4 = $adik4;
    }

    /**
     * @return array|string|string[]
     */
    public function getIconClass()
    {
        return $this->icon_class;
    }

    /**
     * @param array|string|string[] $icon_class
     */
    public function setIconClass($icon_class): void
    {
        $this->icon_class = $icon_class;
    }

    /**
     * @return array
     */
    public function getColName()
    {
        return $this->colName;
    }

    /**
     * @param int $idx
     * @param string $colName
     */
    public function setColName(int $idx, string $colName): void
    {
        $this->colName[$idx] = $colName;
    }

    /**
     * @return string
     */
    public function getColFaden(): string
    {
        return $this->colFaden;
    }

    /**
     * @param string $colFaden
     */
    public function setColFaden(string $colFaden): void
    {
        $this->colFaden = $colFaden;
    }

    /**
     * @return int
     */
    public function getColSpan(): int
    {
        return $this->colSpan;
    }

    /**
     * @param int $colSpan
     */
    public function setColSpan(int $colSpan): void
    {
        $this->colSpan = $colSpan;
    }

    /**
     * @return string
     */
    public function getNadelString(): string
    {
        return $this->nadelString;
    }

    /**
     * @param string $nadelString
     */
    public function setNadelString(string $nadelString): void
    {
        $this->nadelString = $nadelString;
    }

    /**
     * @return string
     */
    public function getIconString(): string
    {
        return $this->iconString;
    }

    /**
     * @param string $iconString
     */
    public function setIconString(string $iconString): void
    {
        $this->iconString = $iconString;
    }

    /**
     * @return string
     */
    public function getIconSize(): string
    {
        return $this->iconSize;
    }

    /**
     * @param mixed $iconSize
     */
    public function setIconSize(string $iconSize): void
    {
        $this->iconSize = $iconSize;
    }

    /**
     * @return int
     */
    public function getCounts(): int
    {
        return $this->counts;
    }

    /**
     * @param int $counts
     */
    public function setCounts(int $counts): void
    {
        $this->counts = $counts;
    }

    public function splitString($str): string
    {
        $array = explode(";", $str);
        $data = '';

        $i = 0;

        foreach ($array as $value) {
            $i == 0 ? $data .= '<strong>' . trim($value) . '</strong><br>' : $data .= '<small>' . trim($value) . '<br></small>';
            $i++;
        }

        return $data;
    }

    public function setStrings(): void
    {
        $nadString = '';

        if ($this->getAmnaz1()) {
            $sep = '';
            for ($i = 0; $i < $this->getAmnaz1(); $i++) {
                if ($i != 0) {
                    $sep = '+';
                }
                $nadString .= $sep . $this->getAmnty1() . '-' . (int)$this->getAmnlg1();
            }
        }

        $this->getAmnaz1() == 1 && $this->getAmnaz2() == 1 ? $nadString .= '+' : $nadString .= '';// Wenn von jeder Nadel nur eine:+ | Wenn nicht leerzeichen

        if ($this->getAmnaz2()) {
            $sep = '';
            for ($i = 0; $i < $this->getAmnaz2(); $i++) {
                if ($i != 0) {
                    $sep = '+';
                }
                $nadString .= $sep . $this->getAmnty2() . '-' . (int)$this->getAmnlg2();
            }
        }

        $this->nadelString = $nadString;

        if ($this->getAmnaz1() == 2) {
            $this->iconString = $this->getAmnty1() . "-" . $this->getAmnty1();
        } elseif ($this->getAmnaz1() == 1 && $this->getAmnaz2() == 1) {
            $this->iconString = $this->getAmnty1() . "-" . $this->getAmnty2();
        } else {
            $this->iconString = $this->getAmnty1();
        }

        $this->iconSize = (int)$this->getAmnlg1() * 2 . 'px';
    }
}