let wrap = function(el) {
    let height = el.offsetHeight + 22;
    let wrapper = document.createRange().createContextualFragment('<div id="filter-wrapper" style="height:' + height + 'px"></div>');

    el.parentNode.insertBefore(wrapper, el);

    let target = document.querySelector('#filter-wrapper');
    target.append(el);
};

let getSiblings = function (e) {
    // for collecting siblings
    let siblings = [];
    // if no parent, return no sibling
    if(!e.parentNode) {
        return siblings;
    }
    // first child of the parent node
    let sibling  = e.parentNode.firstChild;

    // collecting siblings
    while (sibling) {
        if (sibling.nodeType === 1 && sibling !== e) {
            siblings.push(sibling);
        }
        sibling = sibling.nextSibling;
    }

    return siblings;
};

let prevAllFiltered = function (el, filter) {
    let siblings = [];
    while (el = el.previousSibling) { if (!el.classList.contains(filter)) siblings.push(el); }
    return siblings;
}



/*=================================================================
=            Filter Block Affixen und sonstwie handlen            =
=================================================================*/

let anchor = document.getElementById('filternav');
let table = document.querySelector('.table-products');
//let nadselector = [...document.querySelectorAll('.filter-type .nadelsymbol')];
//let captions = document.querySelector('.table-products caption');

// einen Platzhalter machen, damit die Höhe beim affixen bleibt
if (anchor != null) {
    wrap(anchor);


    window.onscroll = function(e) {
        if (window.scrollY > 600) {
            if (window.scrollY > table.getBoundingClientRect().top + window.scrollY - 80) {
                anchor.classList.add('affix');
            } else {
                anchor.classList.remove('affix', 'in');
            }
        }
    };

    [].forEach.call(document.querySelectorAll(".filternav-trigger"), function(el) {
        el.addEventListener('click', function() {
            anchor.classList.toggle('in');
        })
    });

// bei click außerhalb der filternav, wird diese eingefahren (umgeschrieben)
    document.querySelector('html').addEventListener('click', function (e) {
        let filter = document.querySelector('#filternav');
        // console.log(e.target);

        if ((e.target !== filter) && (!filter.contains(e.target))) {
            anchor.classList.remove('in');
        }
    });


    /*============================================
    =            Filter nach Nadeltyp            =
    ============================================*/

    [].forEach.call(document.querySelectorAll('.filter-type .nadelsymbol'), function(el) {
        el.addEventListener('click', function() {
            let evoker = el;
            let filterAttr = evoker.getAttribute("data-nadeltyp");
            let otherTriggers = document.querySelectorAll('.nadelsymbol:not([data-nadeltyp=' + filterAttr + '])');
            let target = document.querySelector('#' + filterAttr);
            let otherTables = document.querySelectorAll('.table-products:not([data-nadeltyp=' + filterAttr + '])');
            let disabled = document.querySelectorAll('.nadelsymbol.disabled').length;
            let enabled = document.querySelectorAll('.nadelsymbol:not(.disabled)').length

            if (disabled == '0') {
                for (let y = 0; y < otherTables.length; y++) {
                    otherTables[y].classList.add('disabled');
                }
                for (let y = 0; y < otherTriggers.length; y++) {
                    otherTriggers[y].classList.add('disabled');
                }

                window.scrollTo({
                    top: target.getBoundingClientRect().top + window.scrollY - 72,
                    behavior: "smooth"
                });

            } else if (!evoker.classList.contains('disabled') && enabled == '1') {
                let list_disabled = document.querySelectorAll('.disabled');

                for (let l = 0; l < list_disabled.length; l++) {
                    list_disabled[l].classList.remove('disabled');
                }

            } else if (evoker.classList.contains('disabled') && enabled >= '1') {
                evoker.classList.remove('disabled');
                target.classList.remove('disabled');

                window.scrollTo({
                    top: target.getBoundingClientRect().top + window.scrollY - 72,
                    behavior: "smooth"
                });

            } else if (!evoker.classList.contains('disabled') && enabled > '1') {
                evoker.classList.add('disabled');
                target.classList.add('disabled');

                let scrollT = prevAllFiltered(target, 'disabled');

                window.scrollTo({
                    top: scrollT[0].getBoundingClientRect().top + window.scrollY - 72,
                    behavior: "smooth"
                });
            }
        })
    });

// ausnahme für click auf alle
    document.getElementById('reset-type').addEventListener("click", function () {
        let list_disabled = document.querySelectorAll('.disabled');

        for (let l = 0; l < list_disabled.length; l++) {
            list_disabled[l].classList.remove('disabled');
        }
    });

// click auf tabelle trigger einen click auf das filtersymbol
    [].forEach.call(document.querySelectorAll('.table-products caption'), function(el) {
        el.addEventListener('click', function() {
            var filterAttr = el.parentNode.getAttribute("id");
            document.querySelector('.nadelsymbol[data-nadeltyp=' + filterAttr + ']').click();
        })
    });


    /*================================================
    =            Filtern nach Fadenstärke            =
    ================================================*/

    document.getElementById('reset-diameter').addEventListener("click", function () {

        [].forEach.call(document.querySelectorAll('.notselected'), function(el) {
            el.classList.remove('notselected');
        });

        [].forEach.call(document.querySelectorAll('tr.selected-EP'), function(el) {
            el.classList.remove('selected-EP');
        });

        [].forEach.call(document.querySelectorAll('tr.selected-USP'), function(el) {
            el.classList.remove('selected-USP');
        });

        [].forEach.call(document.querySelectorAll('.diameter'), function(el) {
            el.classList.remove('on');
            el.removeAttribute('data-iteration');
        })
    });

    [].forEach.call(document.querySelectorAll('.diameter'), function(el) {
        el.addEventListener('click', function(el) {
            let unit = el.target.getAttribute('data-unit');
            let diameter = el.target.getAttribute('data-diameter');
            let columns = [].slice.call(document.querySelectorAll('.col' + unit));

            let selection = columns.filter(column => column.innerHTML.trim() === diameter);

            getSiblings(el.target).forEach(element => element.classList.remove('on'));

            [].forEach.call(document.querySelectorAll('.col' + unit), function(el) {
                el.closest('tr').classList.remove('notselected', 'selected-' + unit);
            });

            if (el.target.classList.contains('on')) {
                selection.forEach(element => element.closest('tr').classList.remove('selected-' + unit));
            } else {
                selection.forEach(element => element.closest('tr').classList.add('selected-' + unit));
            }

            el.target.classList.toggle('on');


            let obj = columns.filter(i => !selection.includes(i.id));
            obj.forEach(element => element.closest('tr').classList.add('notselected'));
        })
    });
}
