<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_produkt',
        'label' => 'product',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'searchFields' => 'routing, product',
        'iconfile' => 'EXT:amdsifu/Resources/Public/Icons/region.svg'
    ],
    'external' => [
        'general' => [
            0 => [
                'connector' => 'csv',
                'parameters' => [
                    'filename' => 'fileadmin/stammdaten/XARIFU.csv',
                    'delimiter' => ",",
                    'text_qualifier' => '"',
                    'skip_rows' => 0,
                    'encoding' => 'latin1'
                ],
                'data' => 'array',
                'referenceUid' => 'refid',
                'pid' => $GLOBALS['TYPO3_CONF_VARS']['EXTENSIONS']['amdsifu']['dataFolderPID'],
                'enforcePid' => true,
                'priority' => 100,
                'description' => 'SERAG IFU-Import'
            ]
        ]
    ],
    'columns' => [
        'active' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_produkt_active',
            'exclude' => 1,
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    '0' => [
                        '0' => 'aktiv',
                        '1' => '1'
                    ],
                    '1' => [
                        '0' => 'inaktiv',
                        '1' => '0'
                    ]
                ]
            ],
            'external' => [
                0 => [
                    'field' => 0
                ]
            ]
        ],
        'refid' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_produkt_refid',
            'exclude' => 1,
            'config' => [
                'type' => 'input',
                'eval' => 'alphanum,trim,required'
            ],
            'external' => [
                0 => [
                    'field' => 1
                ]
            ]
        ],
        'product' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_product_product',
            'exclude' => 1,
            'config' => [
                'type' => 'input',
                'eval' => 'trim,required',
            ],
            'external' => [
                0 => [
                    'field' => 2
                ]
            ]
        ],
        'budi' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_product_budi',
            'exclude' => 1,
            'config' => [
                'type' => 'input',
                'eval' => 'trim',
            ],
            'external' => [
                0 => [
                    'field' => 9
                ]
            ]
        ],
        'sort' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_product_sort',
            'exclude' => 1,
            'config' => [
                'type' => 'input',
                'eval' => 'trim,alphanum,required'
            ],
            'external' => [
                0 => [
                    'field' => 4
                ]
            ]
        ],
        'cat' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_product_cat',
            'exclude' => 1,
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    '0' => [
                        '0' => 'Zubehör',
                        '1' => 'ZUBEH'
                    ],
                    '1' => [
                        '0' => 'Nahtmaterial',
                        '1' => 'NM'
                    ],
                    '2' => [
                        '0' => 'Netze',
                        '1' => 'NETZE'
                    ]
                ]
            ],
            'external' => [
                0 => [
                    'field' => 5
                ]
            ]
        ],
        'routing_alt' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_product_routing_alt',
            'exclude' => 1,
            'config' => [
                'type' => 'input',
                'eval' => 'trim,alphanum'
            ],
            'external' => [
                0 => [
                    'field' => 6
                ]
            ]
        ],
        'routing' => [
            'label' => 'LLL:EXT:amdsifu/Resources/Private/Language/locallang.xlf:tx_amdsIfu_product_routing',
            'exclude' => 1,
            'config' => [
                'type' => 'input',
                'eval' => 'trim,alphanum,required'
            ],
            'external' => [
                0 => [
                    'field' => 7
                ]
            ]
        ]
    ],
    'types' => [
        '0' => [
            'showitem' => 'refid, product, budi, sort, cat, routing_alt, routing'
        ]
    ]
];
