<?php
defined('TYPO3') || die();

/**
 * Temporary variables
 */
$extensionKey = 'amdsifu';
$doktypeID = '2';

/**
 * Default PageTS
 */
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::registerPageTSConfigFile(
    $extensionKey,
    'Configuration/TsConfig/Page/All.tsconfig',
    'IFU: BackendLayouts, TCEMAIN, TCEFORM, RTE'
);


\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTcaSelectItem(
    'pages',
    'doktype',
    [
        'IFU-Produkt',
        $doktypeID,
        'record-ifu-page'
    ],
    'after'
);

$product_fields = [
    'file_collection' => [
        'label' => 'IFU Dateien',
        'config' => [
            'type' => 'inline',
            'foreign_table' => 'sys_file_collection',
            'maxitems' => 1,
        ],
    ],
    'colorscheme' => [
        'exclude' => true,
        'l10n_mode' => 'exclude',
        'l10n_display' => 'defaultAsReadonly',
        'label' => 'Farbschema',
        'config' => [
            'type' => 'input',
            'renderType' => 'colorpicker',
            'size' => 9,
            'valuePicker' => [
                'items' => [
                    ['default', '#e10388'],
                    ['SERAPID', '#f099be'],
                    ['SERAFIT', '#a69dc8'],
                    ['SERAFAST', '#88278d'],
                    ['SERASYNTH', '#bcbec0'],
                    ['SERATAN', '#797d96'],
                    ['SERALON', '#f16937'],
                    ['SUPRAMID', '#f16937'],
                    ['NYLON', '#f16937'],
                    ['SULENE', '#49ae56'],
                    ['TERYLENE', '#49ae56'],
                    ['SERACOR', '#ee2f31'],
                    ['SERAPREN', '#0098cb'],
                    ['SERALENE', '#0095a0'],
                    ['SERAMON', '#31836f'],
                    ['SERAFLEX', '#64ccef'],
                    ['SERANOX', '#aeaca7'],
                    ['SERATIM', '#4ebae8'],
                    ['SERATOM', '#4ebae8'],
                    ['SERATEX', '#4ebae8'],
                    ['SERAMESH', '#4ebae8'],
                    ['SERASIS', '#4ebae8'],
                    ['SERAGYN', '#cbe6f9'],
                    ['SERASYNTH MESH', '#c6c6c6'],
                ],
            ],
        ],
    ]
];

\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns(
    'pages',
    $product_fields
);

$GLOBALS['TCA']['pages']['palettes']['eifu_config'] = array(
    'showitem' => 'file_collection,--linebreak--,colorscheme'
);

\TYPO3\CMS\Core\Utility\ArrayUtility::mergeRecursiveWithOverrule(
    $GLOBALS['TCA']['pages'],
    [
        'ctrl' => [
            'typeicon_classes' => [
                $doktypeID => 'record-ifu-page'
            ],
        ],
        'types' => [
            
            // Video
            $doktypeID => [
                'showitem' => '
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:general,
                    --palette--;;standard,
                    --palette--;;title,
                --div--;eIFU Sachen,
                    --palette--;eIFU Sachen;eifu_config,
                    --palette--;;media,
                --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:pages.tabs.metadata,
                    --palette--;;abstract,
                    --palette--;;metatags,
                    --palette--;;editorial,
                --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:pages.tabs.appearance,
                    --palette--;;layout,
                    --palette--;;replace,
                --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:pages.tabs.behaviour,
                    --palette--;;links,
                    --palette--;;caching,
                    --palette--;;miscellaneous,
                    --palette--;;module,
                --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:pages.tabs.resources,
                    --palette--;;config,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:language,
                    --palette--;;language,
                --div--;LLL:EXT:frontend/Resources/Private/Language/locallang_tca.xlf:pages.tabs.access,
                    --palette--;;visibility,
                    --palette--;;access,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:categories,
                    categories,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:notes,
                    rowDescription,
                --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:extended,
            '
            ],
        ]
    ]
);
