<?php

namespace Amadeus\Amdsifu\Domain\Repository;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;

class ProduktRepository extends Repository
{
    public function initializeObject(): void {
        $querySettings = GeneralUtility::makeInstance(Typo3QuerySettings::class);

        $querySettings->setRespectStoragePage(false);
        $querySettings->setStoragePageIds(array(3));
        $querySettings->setRespectSysLanguage(FALSE);

        $this->setDefaultQuerySettings($querySettings);
    }

    public function findProductByRefid(string $search) {
        $query = $this->createQuery();
        $query->matching(
            $query->like('refid', '%' . $search  . '%')
        );

        $result = $query->execute();

        if ($result instanceof QueryResultInterface) {
            return $result->getFirst();
        } elseif (is_array($result)) {
            return $result[0] ?? null;
        } else {
            return $result;
        }
    }
}