<?php


namespace Amadeus\Amdsifu\Controller;

use Amadeus\Amdsifu\Domain\Repository\ProduktRepository;
use Amadeus\Amdsifu\Domain\Repository\RelationRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class AjaxController extends ActionController
{
    private $produktRepo;
    private $relRepo;
    
    
    public function injectProduktRepository(ProduktRepository $produktRepository): void
    {
        $this->produktRepo = $produktRepository;
    }
    
    public function injectRelationRepository(RelationRepository $relationRepository): void
    {
        $this->relRepo = $relationRepository;
    }
    
    /**
     * Hier API-Daten zusammenstellen
     *
     * @return false|string
     */
    public function doSearchAction(): false|string
    {
        $raw_data = $this->produktRepo->findAll()->toArray();
        $relations = $this->relRepo->findAll()->toArray();
        $relation_table = array();
        
        $labelBUDI = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('tx_amdsIfu_product_budi', 'amdsifu');
        $labelREF = \TYPO3\CMS\Extbase\Utility\LocalizationUtility::translate('tx_amdsIfu_produkt_refid', 'amdsifu');
        
        for ($e = 0; $e < count($relations); $e++) {
            $row = $relations[$e];
            $relation_table[$row->getRouting()] = $row->getTarget();
        }
        
        $result = array();
        
        for ($i = 0; $i < count($raw_data); $i++) {
            $data = array();
            $row = $raw_data[$i];
            $id2 = $row->getRouting() . '_' . $row->getSort();
            
            if (array_key_exists($id2, $relation_table)) {
                $lpid = $relation_table[$id2];
            } else {
                continue;
            }
            
            $url = $this->uriBuilder
                ->reset()
                ->setLanguage("current")
                ->setTargetPageUid($lpid)
                ->build();
            
            $data["value"] = $url;
            $data["label"] = '<span class="text-muted">' . $row->getProduct() . '</span><br><small>' . $labelREF . ': <b>' . $row->getRefid() . '</b>' . (!empty($row->getBudi()) ? ' – ' . $labelBUDI . ': <b>' . $row->getBudi() .'</b>' : '') . '</small>';
            $data["customProperties"]["product"] = $row->getProduct();
            $data["customProperties"]["budi"] = $row->getBudi();
            $data["customProperties"]["refid"] = $row->getRefid();
            
            $result[] = $data;
        }
        
        return json_encode($result, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    }
}
