<?php

namespace amadeus\AmdsEvents\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Event extends AbstractEntity
{
    /**
     * @var int
     */
    protected $termin;

    /**
     * @var int
     */
    protected $terminStart;

    /**
     * @var int
     */
    protected $terminEnd;

    /**
     * @var string
     */
    protected $locationSimple;

    /**
     * @var string
     */
    protected $title;

    /**
     * @var int
     */
    protected $uid;

    public function __construct(int $c_termin = 0, int $c_tStart = 0, int $c_tEnd = 0, string $c_locSimple = '', string $c_title = '', int $c_uid = 0) {
        $this->setTermin($c_termin);
        $this->setTerminStart($c_tStart);
        $this->setTerminEnd($c_tEnd);
        $this->setLocationSimple($c_locSimple);
        $this->setTitle($c_title);
        $this->setUid($c_uid);
    }

    /**
     * @return int
     */
    public function getTermin(): int
    {
        return $this->termin;
    }

    /**
     * @param int $termin
     */
    public function setTermin($termin): void
    {
        $this->termin = $termin;
    }

    /**
     * @return int
     */
    public function getTerminStart(): int
    {
        return $this->terminStart;
    }

    /**
     * @param int $terminStart
     */
    public function setTerminStart($terminStart): void
    {
        $this->terminStart = $terminStart;
    }

    /**
     * @return mixed
     */
    public function getTerminEnd()
    {
        return $this->terminEnd;
    }

    /**
     * @param mixed $terminEnd
     */
    public function setTerminEnd($terminEnd)
    {
        $this->terminEnd = $terminEnd;
    }

    /**
     * @return string
     */
    public function getLocationSimple(): string
    {
        return $this->locationSimple;
    }

    /**
     * @param string $locationSimple
     */
    public function setLocationSimple(string $locationSimple)
    {
        $this->locationSimple = $locationSimple;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title)
    {
        $this->title = $title;
    }

    /**
     * @return int
     */
    public function getUid(): int
    {
        return $this->uid;
    }

    /**
     * @param mixed $uid
     */
    public function setUid($uid)
    {
        $this->uid = $uid;
    }


}