<?php


namespace amadeus\AmdsEvents\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class AnmeldungController extends ActionController
{
    public function databaseNext() {
        $current = time();

        $dateBegin = mktime(0, 0, 0, date('n'), date('j') + 1, date('Y'));
        $dateEnd = mktime(0, 0, 0, date('n'), date('j') + 1, date('Y'));
        $GETvars = \TYPO3\CMS\Core\Utility\GeneralUtility::_GET();

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_news_domain_model_news');
        $result = $queryBuilder
            ->select('*')
            ->from('tx_news_domain_model_news')
            ->where(
                $queryBuilder->expr()->neq('pid', $queryBuilder->createNamedParameter($this->settings['excludepage'])),
                $queryBuilder->expr()->eq('is_event', 1),
                $queryBuilder->expr()->gt('datetime', $current),
                $queryBuilder->expr()->eq('hidden', 0),
                $queryBuilder->expr()->eq('deleted', 0)
            )
            ->orderBy('datetime')
            ->execute();

        $rows = $result->fetchAll();
        return $rows;
    }

    public function databaseThis(int $num) {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_news_domain_model_news');
        $result = $queryBuilder
            ->select('*')
            ->from('tx_news_domain_model_news')
            ->where(
                $queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter($num))
            )
            ->execute();

        $rows = $result->fetchAll();
        return $rows;
    }

    public function listAction() {
        $events = $this->databaseNext();

        $this->view->assign('events', $events);
        $this->view->assign('target', $this->settings['detailpage']);

        return $this->view->render();
    }

    public function detailAction(int $currentUid) {
        $current = $this->databaseThis($currentUid)[0];

        $this->view->assign('event', $current);

        return $this->view->render();
    }
}