<?php


namespace amadeus\AmdsEvents\Controller;

use amadeus\AmdsEvents\Domain\Model\Fingerprint;
use amadeus\AmdsEvents\Domain\Model\Registration;
use amadeus\AmdsEvents\Domain\Repository\FingerprintRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class AnmeldungController extends ActionController
{
    private $regrepo;

    public function injectFingerprintRepository(FingerprintRepository $fingerprintRepository):void {
        $this->regrepo = $fingerprintRepository;
    }

    public function databaseNext(int $excludePid = null) {
        $current = time();

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_news_domain_model_news');
        $result = $queryBuilder
            ->select('*')
            ->from('tx_news_domain_model_news')
            ->where(
                $queryBuilder->expr()->neq('pid', $queryBuilder->createNamedParameter((is_null($excludePid)) ? $this->settings['excludepage'] : $excludePid)),
                $queryBuilder->expr()->eq('is_event', 1),
                $queryBuilder->expr()->gt('datetime', $current),
                $queryBuilder->expr()->eq('hidden', 0),
                $queryBuilder->expr()->eq('deleted', 0)
            )
            ->orderBy('datetime')
            ->execute();

        return $result->fetchAll();
    }

    public function databaseOnly(int $includePid = null) {
        $current = time();

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_news_domain_model_news');
        $result = $queryBuilder
            ->select('*')
            ->from('tx_news_domain_model_news')
            ->where(
                $queryBuilder->expr()->eq('pid', $queryBuilder->createNamedParameter($includePid)),
                $queryBuilder->expr()->eq('is_event', 1),
                $queryBuilder->expr()->gt('datetime', $current),
                $queryBuilder->expr()->eq('hidden', 0),
                $queryBuilder->expr()->eq('deleted', 0)
            )
            ->orderBy('datetime')
            ->execute();

        return $result->fetchAll();
    }

    public function databaseThis(int $num) {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_news_domain_model_news');
        $result = $queryBuilder
            ->select('*')
            ->from('tx_news_domain_model_news')
            ->where(
                $queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter($num))
            )
            ->execute();

        return $result->fetchAll();
    }

    public function listAction() {
        $events = $this->databaseNext();

        $this->view->assign('events', $events);
        $this->view->assign('target', $this->settings['detailpage']);

        return $this->view->render();
    }

    public function detailAction(int $currentUid) {
        $current = $this->databaseThis($currentUid)[0];

        $this->view->assign('event', $current);

        return $this->view->render();
    }

    public function newsAction() {
        $events = $this->databaseOnly(161);

        $this->view->assign('events', $events);

        return $this->view->render();
    }

    public function mailAction(Registration $registration) {
        //$context = $registration->getAction();
        $registrationId = hash('sha256',$registration->getAction() . "-" . $registration->getEmail());

        $this->view->assign('registration', $registration);
        $this->view->assign('bestellNr', date('ymdhi'));

        $subject = 'Hospitationsanmeldung | SERAG-WIESSNER - ' . date('ymdhi');

        $headerData = 'From: SERAG-WIESSNER GmbH & Co. KG <info@serag-wiessner.de>' . "\n";
        $headerData .= 'Reply-To: info@serag-wiessner.de' . "\n";
        $headerData .= 'Bcc: heike.riedel@serag-wiessner.de,anja.rucker@serag-wiessner.de,joerg.guenther@serag-wiessner.de,stefan.schirmer@amadeus-agentur.com' . "\n";
        $headerData .= 'X-Mailer: PHP/' . phpversion() . "\n";
        $headerData .= 'MIME-Version: 1.0' . "\n";
        $headerData .= 'Content-type: text/html; charset=utf-8' . "\n";

        $htmlOut = $this->view->render();

        if ($this->regrepo->countFingerprintsByInput($registrationId) == 0) {
            if (mail($registration->getEmail(), $subject, $htmlOut, $headerData)) {
                $this->regrepo->add(new Fingerprint($registrationId));
                unset($registration);
                header('Location: https://' . $_SERVER['HTTP_HOST'] . '/index.php?id=82');
           }
        }

        return $this->view->render();
    }
}