<?php

namespace amadeus\AmdsEvents\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Event extends AbstractEntity
{
    protected $termin;
    protected $terminStart;
    protected $terminEnd;
    protected $locationSimple = '';
    protected $title = "";
    protected $uid;

    public function __construct(int $c_termin = 0, int $c_tStart = 0, int $c_tEnd = 0, string $c_locSimple = '', string $c_title = '', int $c_uid) {
        $this->setTermin($c_termin);
        $this->setTerminStart($c_tStart);
        $this->setTerminEnd($c_tEnd);
        $this->setLocationSimple($c_locSimple);
        $this->setTitle($c_title);
        $this->setUid($c_uid);
    }

    /**
     * @return mixed
     */
    public function getTermin()
    {
        return $this->termin;
    }

    /**
     * @param mixed $termin
     */
    public function setTermin($termin)
    {
        $this->termin = $termin;
    }

    /**
     * @return mixed
     */
    public function getTerminStart()
    {
        return $this->terminStart;
    }

    /**
     * @param mixed $terminStart
     */
    public function setTerminStart($terminStart)
    {
        $this->terminStart = $terminStart;
    }

    /**
     * @return mixed
     */
    public function getTerminEnd()
    {
        return $this->terminEnd;
    }

    /**
     * @param mixed $terminEnd
     */
    public function setTerminEnd($terminEnd)
    {
        $this->terminEnd = $terminEnd;
    }

    /**
     * @return string
     */
    public function getLocationSimple(): string
    {
        return $this->locationSimple;
    }

    /**
     * @param string $locationSimple
     */
    public function setLocationSimple(string $locationSimple)
    {
        $this->locationSimple = $locationSimple;
    }

    /**
     * @return string
     */
    public function getTitle(): string
    {
        return $this->title;
    }

    /**
     * @param string $title
     */
    public function setTitle(string $title)
    {
        $this->title = $title;
    }

    /**
     * @return mixed
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * @param mixed $uid
     */
    public function setUid($uid)
    {
        $this->uid = $uid;
    }


}