<?php


namespace amadeus\AmdsEvents\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use amadeus\AmdsEvents\Domain\Model\Event;

class AnmeldungController extends ActionController
{
    private $events = array();

    public function databaseNext() {
        $current = time();

        $dateBegin = mktime(0, 0, 0, date('n'), date('j') + 1, date('Y'));
        $dateEnd = mktime(0, 0, 0, date('n'), date('j') + 1, date('Y'));
        $GETvars = \TYPO3\CMS\Core\Utility\GeneralUtility::_GET();
        // $GETvars["showAll"] ? $dateWhere = "AND datetime > $dateBegin" : $dateWhere = "AND datetime BETWEEN $dateBegin AND $dateEnd" ;
        // $SQL  = "SELECT * FROM tx_news_domain_model_news WHERE pid<>" . $this->settings['excludepage'] . "AND is_event=1 " . $dateWhere . " AND hidden=0 AND deleted=0 ORDER BY datetime ASC";

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_news_domain_model_news');
        $result = $queryBuilder
            ->select('*')
            ->from('tx_news_domain_model_news')
            ->where(
                $queryBuilder->expr()->neq('pid', $queryBuilder->createNamedParameter($this->settings['excludepage'])),
                $queryBuilder->expr()->eq('is_event', 1),
                $queryBuilder->expr()->gt('datetime', $current),
                $queryBuilder->expr()->eq('hidden', 0),
                $queryBuilder->expr()->eq('deleted', 0)
            )
            ->orderBy('datetime')
            ->execute();

        $rows = $result->fetchAll();
        $this->events = $rows;
        return $rows;
    }

    public function listAction() {
        $events = $this->databaseNext();

        $this->view->assign('events', $events);

        return $this->view->render();
    }

    public function detailAction() {

    }
}