<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet',
        'label' => 'plz',
        'label_alt' => 'ort',
        'label_alt_force' => true,
        'iconfile' => 'EXT:amds_plz/Resources/Public/Icons/region.svg'
    ],
    'external' => [
        'general' => [
            0 => [
                'connector' => 'csv',
                'parameters' => [
                    'filename' => 'fileadmin/stammdaten/REGIONS.csv',
                    'delimiter' => ",",
                    'text_qualifier' => '"',
                    'skip_rows' => 0,
                    'encoding' => 'utf8'
                ],
                'data' => 'array',
                'referenceUid' => 'plz',
                'pid' => 43,
                'enforcePid' => true,
                'priority' => 100,
                'description' => 'SERAG Regionen-Import'
            ]
        ]
    ],
    'columns' => [
        'plz' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.postleitzahl',
            'config' => [
                'type' => 'input',
                'size' => '10',
                'eval' => 'num,required',
                'max' => '5'
            ],
            'external' => [
                0 => [
                    'field' => 0
                ]
            ]
        ],
        'ort' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.bezeichnung',
            'config' => [
                'type' => 'input',
                'eval' => 'trim'
            ],
            'external' => [
                0 => [
                    'field' => 1
                ]
            ]
        ],
        'bundesland' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.bundesland',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    '0' => [
                        '0' => 'Baden-Württemberg',
                        '1' => 'Baden-Württemberg'
                    ],
                    '1' => [
                        '0' => 'Bayern',
                        '1' => 'Bayern'
                    ],
                    "2" => [
                        '0' => 'Berlin',
                        '1' => 'Berlin'
                    ],
                    '3' => [
                        '0' => 'Brandenburg',
                        '1' => 'Brandenburg'
                    ],
                    '4' => [
                        '0' => 'Bremen',
                        '1' => 'Bremen'
                    ],
                    '5' => [
                        '0' => 'Hamburg',
                        '1' => 'Hamburg'
                    ],
                    '6' => [
                        '0' => 'Hessen',
                        '1' => 'Hessen'
                    ],
                    '7' => [
                        '0' => 'Mecklenburg-Vorpommern',
                        '1' => 'Mecklenburg-Vorpommern'
                    ],
                    '8' => [
                        '0' => 'Niedersachsen',
                        '1' => 'Niedersachsen'
                    ],
                    '9' => [
                        '0' => 'Nordrhein-Westfalen',
                        '1' => 'Nordrhein-Westfalen'
                    ],
                    '10' => [
                        '0' => 'Rheinland-Pfalz',
                        '1' => 'Rheinland-Pfalz'
                    ],
                    '11' => [
                        '0' => 'Saarland',
                        '1' => 'Saarland'
                    ],
                    '12' => [
                        '0' => 'Sachsen',
                        '1' => 'Sachsen'
                    ],
                    '13' => [
                        '0' => 'Sachsen-Anhalt',
                        '1' => 'Sachsen-Anhalt'
                    ],
                    '14' => [
                        '0' => 'Schleswig-Holstein',
                        '1' => 'Schleswig-Holstein'
                    ],
                    '15' => [
                        '0' => 'Thüringen',
                        '1' => 'Thüringen'
                    ]
                ]
            ],
            'external' => [
                0 => [
                    'field' => 2
                ]
            ]
        ],
        'auslieferung' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.auslieferungsart',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    '0' => [
                        '0' => 'Zustellung',
                        '1' => 'Zustellung'
                    ],
                    '1' => [
                        '0' => 'Postfach',
                        '1' => 'Postfach'
                    ],
                    '2' => [
                        '0' => 'Zustellung+Postfach',
                        '1' => 'Zustellung+Postfach'
                    ],
                    '3' => [
                        '0' => 'Einzel-Großempfänger',
                        '1' => 'Einzel-Großempfänger'
                    ],
                    '4' => [
                        '0' => 'Gruppen-Großempfänger',
                        '1' => 'Gruppen-Großempfänger'
                    ]
                ]
            ],
            'external' => [
                0 => [
                    'field' => 3
                ]
            ]
        ],
        'vertreternaht' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.vertreter_nm',
            'config' => [
                'type' => 'input',
                'size' => '10',
                'eval' => 'num,required',
                'max' => '4'
            ],
            'external' => [
                0 => [
                    'field' => 4
                ]
            ]
        ],
        'vertreterimpl' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.vertreter_impl',
            'config' => [
                'type' => 'input',
                'size' => '10',
                'eval' => 'num,required',
                'max' => '4'
            ],
            'external' => [
                0 => [
                    'field' => 5
                ]
            ]
        ],
        'vertreterloes' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_gebiet.vertreter_loes',
            'config' => [
                'type' => 'input',
                'size' => '10',
                'eval' => 'num,required',
                'max' => '4'
            ],
            'external' => [
                0 => [
                    'field' => 6
                ]
            ]
        ]
    ],
    'types' => [
        '0' => [
            'showitem' => 'plz, ort, auslieferung, vertreternaht, vertreterimpl, vertreterloes'
        ]
    ]
];