<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent',
        'label' => 'nachname',
        'label_alt' => 'vorname',
        'label_alt_force' => true,
        'iconfile' => 'EXT:amds_plz/Resources/Public/Icons/agent.svg'
    ],
    'external' => [
        'general' => [
            0 => [
                'connector' => 'csv',
                'parameters' => [
                    'filename' => 'fileadmin/stammdaten/AGENTS.csv',
                    'delimiter' => ",",
                    'text_qualifier' => '"',
                    'skip_rows' => 0,
                    'encoding' => 'utf8'
                ],
                'data' => 'array',
                'referenceUid' => 'kennung',
                'pid' => 43,
                'enforcePid' => true,
                'priority' => 100,
                'description' => 'SERAG Außendienst-Import'
            ]
        ]
    ],
    'columns' => [
        'kennung' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.codenummer',
            'config' => [
                'type' => 'input',
                'size' => '10',
                'eval' => 'trim,num,required'
            ],
            'external' => [
                0 => [
                    'field' => 0
                ]
            ]
        ],
        'bereich' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.bereich',
            'config' => [
                /*
                *  Würde theoretisch Sinn machen, hier ein SingleSelect zu nutzen, wenn von Hand im Backend angelegt werden soll.
                *  Da wir aber bei SW mit fertigen Imports arbeiten, tut es auch ein normaler Input
                */
                'type' => 'input',
                'size' => '10',
                'eval' => 'trim,num,required'
            ],
            'external' => [
                0 => [
                    'field' => 1
                ]
            ]
        ],
        'vorname' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.vorname',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim,required'
            ],
            'external' => [
                0 => [
                    'field' => 2
                ]
            ]
        ],
        'nachname' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.nachname',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim,required'
            ],
            'external' => [
                0 => [
                    'field' => 3
                ]
            ]
        ],
        'strasse' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.strasse',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim'
            ],
            'external' => [
                0 => [
                    'field' => 4
                ]
            ]
        ],
        'plz' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.postleitzahl',
            'config' => [
                'type' => 'input',
                'size' => '10',
                'eval' => 'num,nospace',
                'max' => '5'
            ],
            'external' => [
                0 => [
                    'field' => 5
                ]
            ]
        ],
        'ort' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.ort',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim'
            ],
            'external' => [
                0 => [
                    'field' => 6
                ]
            ]
        ],
        'telefon' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.telefonnummer',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim'
            ],
            'external' => [
                0 => [
                    'field' => 7
                ]
            ]
        ],
        'fax' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.faxnummer',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim'
            ],
            'external' => [
                0 => [
                    'field' => 8
                ]
            ]
        ],
        'mobil' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.mobilnummer',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim'
            ],
            'external' => [
                0 => [
                    'field' => 9
                ]
            ]
        ],
        'email' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.email',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim,email'
            ],
            'external' => [
                0 => [
                    'field' => 10
                ]
            ]
        ],
        'url' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.website',
            'config' => [
                'type' => 'input',
                'size' => '20',
                'eval' => 'trim,alphanum_x,domainname'
            ]
        ],
        'memo' => [
            'label' => 'LLL:EXT:amds_plz/Resources/Private/Language/locallang_db.xlf:tx_lampplzsuche_domain_model_agent.memo',
            'config' => [
                'type' => 'input',
                'size' => '40'
            ]
        ]
    ],
    'types' => [
        '0' => [
            'showitem' => 'kennung, bereich, vorname, nachname, strasse, plz, ort, telefon, fax, mobil, email'
        ]
    ]
];
