<?php

namespace Amadeus\AmdsPlz\Domain\Model;

use \TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Gebiet extends AbstractEntity
{
    protected $plz = 0;
    protected $ort = '';
    protected $bundesland = '';
    protected $auslieferung = '';
    protected $vertreternaht = 0;
    protected $vertreterimpl = 0;
    protected $vertreterloes = 0;

    public function __construct(int $plz, string $ort = '', string $bundesland = '', string $art_auslieferung = '', int $vrt_nm = 0, int $vrt_impl = 0, int $vrt_loes = 0) {
        $this->setPlz($plz);
        $this->setOrt($ort);
        $this->setBundesland($bundesland);
        $this->setAuslieferung($art_auslieferung);
        $this->setVertreternaht($vrt_nm);
        $this->setVertreterimpl($vrt_impl);
        $this->setVertreterloes($vrt_loes);
    }

    public function setPlz(int $input):void {
        $this->plz = $input;
    }

    public function getPlz():int {
        return $this->plz;
    }

    public function setOrt(string $input):void {
        $this->ort = $input;
    }

    public function getOrt():string {
        return $this->ort;
    }

    public function setBundesland(string $input):void {
        $this->bundesland = $input;
    }

    public function getBundesland():string {
        return $this->bundesland;
    }

    public function setAuslieferung(string $input):void {
        $this->auslieferung = $input;
    }

    public function getAuslieferung():string {
        return $this->auslieferung;
    }

    public function setVertreternaht(int $input):void {
        $this->vertreternaht = $input;
    }

    public function getVertreternaht():int {
        return $this->vertreternaht;
    }

    public function setVertreterimpl(int $input):void {
        $this->vertreterimpl = $input;
    }

    public function getVertreterimpl():int {
        return $this->vertreterimpl;
    }

    public function setVertreterloes(int $input):void {
        $this->vertreterloes = $input;
    }

    public function getVertreterloes():int {
        return $this->vertreterloes;
    }
}