<?php

namespace Amadeus\AmdsPlz\Controller;

use Amadeus\AmdsPlz\Domain\Model\Input;
use Amadeus\AmdsPlz\Domain\Repository\AgentRepository;
use Amadeus\AmdsPlz\Domain\Repository\GebietRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Psr\Http\Message\ResponseInterface;

class SearchController extends ActionController
{
    private $agentRepo;
    private $locationRepo;

    public function injectAgentRepository(AgentRepository $agentRepository):void {
        $this->agentRepo = $agentRepository;
    }

    public function injectGebietRepository(GebietRepository $gebietRepository):void {
        $this->locationRepo = $gebietRepository;
    }

    /**
     * @return ResponseInterface
     */
    public function searchAction(): ResponseInterface {
        $input = new Input();
        $this->view->assign('input', $input);

        return $this->htmlResponse();
    }

    /**
     * @param Input $input The input received from the user
     * @return ResponseInterface
     */
    public function resultAction(Input $input): ResponseInterface {
        $query = $input->getField();
        $location = $this->locationRepo->findPlz($query);
        $output = array();

        if ($location != NULL) {
            $vrt_nt = $this->agentRepo->findByKennung($location->getVertreternaht());
            if ($vrt_nt != NULL) {
                $output[0] = $vrt_nt;
            } else {
                $output[0] = '';
            }
            $vrt_impl = $this->agentRepo->findByKennung($location->getVertreterimpl());
            if ($vrt_impl != NULL) {
                $output[1] = $vrt_impl;
            } else {
                $output[1] = '';
            }
            $vrt_loes = $this->agentRepo->findByKennung($location->getVertreterloes());
            if ($vrt_loes != NULL) {
                $output[2] = $vrt_loes;
            } else {
                $output[2] = '';
            }
        }

        $this->view->assign('location', $location);
        $this->view->assign('agents', $output);

        return $this->htmlResponse();
    }
}