<?php

namespace amadeus\amds_plz\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;

class GebietRepository extends Repository
{
    public function findPlz(int $search) {
        $query = $this->createQuery();
        $query->matching($query->equals('plz', $search));
        $query -> setLimit(1);
        $result = $query->execute();

        if ($result instanceof QueryResultInterface) {
            return $result->getFirst();
        }
        if (is_array($result)) {
            return $result[0] ?? null;
        }
    }

    public function countByPlz(string $search):int {
        $query = $this->createQuery();
        $query->matching($query->equals('plz', $search));
        return $query->execute()->count();
    }
}