<?php

namespace amadeus\amds_plz\Controller;

use amadeus\amds_plz\Domain\Model\Input;
use amadeus\amds_plz\Domain\Repository\AgentRepository;
use amadeus\amds_plz\Domain\Repository\GebietRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use Psr\Http\Message\ResponseInterface;

class SearchController extends ActionController
{
    private $agentRepo;
    private $locationRepo;

    public function injectAgentRepository(AgentRepository $agentRepository):void {
        $this->agentRepo = $agentRepository;
    }

    public function injectGebietRepository(GebietRepository $gebietRepository):void {
        $this->locationRepo = $gebietRepository;
    }

    public function searchAction() {
        $input = new Input();
        $this->view->assign('input', $input);
        return $this->view->render();
    }

    /**
     * @param object $input The input received from the user
     * @return string
     */
    public function resultAction(Input $input) {
        $query = $input->getField();
        $location = $this->locationRepo->findPlz($query);
        $output = array();

        if ($location != NULL) {
            $vrt_nt = $this->agentRepo->findByKennung($location->getVertreternaht());
            if ($vrt_nt != NULL) {
                $output[0] = $vrt_nt;
            } else {
                $output[0] = '';
            }
            $vrt_impl = $this->agentRepo->findByKennung($location->getVertreterimpl());
            if ($vrt_impl != NULL) {
                $output[1] = $vrt_impl;
            } else {
                $output[1] = '';
            }
            $vrt_loes = $this->agentRepo->findByKennung($location->getVertreterloes());
            if ($vrt_loes != NULL) {
                $output[2] = $vrt_loes;
            } else {
                $output[2] = '';
            }
        }

        $this->view->assign('location', $location);
        $this->view->assign('agents', $output);
        return $this->view->render();
    }

//    Gibt bei TYPO3v11 folgende Änderung: From version 11 on Extbase expects actions to return an instance of PsrHttpMessageResponseInterface.
//    Unten die Funktion, gebaut wie in der Dokumentation angegeben. Sie breakt aber momentan, da htmlResponse() in der Klasse nicht vorhanden ist. Evtl. muss man sie selbst schreiben, habe aber keine Ahnung was da dann hinein soll (Zeile 48 vllt.?)
//
//    public function resultAction(string $input):ResponseInterface {
//        $query = $input->getField();
//        $location = $this->locationRepo->findOneByPlz($query);
//        $output = array();
//
//        if ($location != NULL) {
//            $output[0] = $this->agentRepo->findByIdentifier($location->getVertreternaht());
//            $output[1] = $this->agentRepo->findByIdentifier($location->getVertreterimpl());
//            $output[2] = $this->agentRepo->findByIdentifier($location->getVertreterloes());
//        }
//
//        // wieder aus der Dokumentation übernommen. Testweise location als Rückgabe, wäre später $output
//        $this->view->assign('agents', $output);
//        $this->view->assign('agents', $output);
//        return $this->htmlResponse();
//    }
}