<?php

namespace amadeus\amds_plz\Domain\Model;

use \TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Gebiet extends AbstractEntity
{
    protected $plz = '';
    protected $ort = '';
    protected $bundesland = '';
    protected $auslieferung = '';
    protected $vertreternaht = 0;
    protected $vertreterimpl = 0;
    protected $vertreterloes = 0;

    public function __construct(string $plz = '', string $ort = '', string $bundesland = '', string $art_auslieferung = '', int $vrt_nm = 0, int $vrt_impl = 0, int $vrt_loes = 0) {
        $this->setPlz($plz);
        $this->setOrt($ort);
        $this->setBundesland($bundesland);
        $this->setAuslieferung($art_auslieferung);
        $this->setVertreterNaht($vrt_nm);
        $this->setVertreterImpl($vrt_impl);
        $this->setVertreterLoes($vrt_loes);
    }

    public function setPlz(string $input):void {
        $this->plz = $input;
    }

    public function getPlz():string {
        return $this->plz;
    }

    public function setOrt(string $input):void {
        $this->ort = $input;
    }

    public function getOrt():string {
        return $this->ort;
    }

    public function setBundesland(string $input):void {
        $this->bundesland = $input;
    }

    public function getBundesland():string {
        return $this->bundesland;
    }

    public function setAuslieferung(string $input):void {
        $this->auslieferung = $input;
    }

    public function getAuslieferung():string {
        return $this->auslieferung;
    }

    public function setVertreternaht(int $input):void {
        $this->vertreternaht = $input;
    }

    public function getVertreternaht():string {
        return $this->vertreternaht;
    }

    public function setVertreterimpl(int $input):void {
        $this->vertreterimpl = $input;
    }

    public function getVertreterimpl():string {
        return $this->vertreterimpl;
    }

    public function setVertreterloes(int $input):void {
        $this->vertreterloes = $input;
    }

    public function getVertreterloes():string {
        return $this->vertreterloes;
    }
}